/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.log;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.log.AbstractLogFilter;

class LevelResolver
implements AbstractLogFilter.ILevelResolver {
    private Map<String, String> localizedLevels;

    LevelResolver() {
        Locale logLocale = this.getLogLocale();
        String logBundle = this.getLogBundle();
        this.localizedLevels = new HashMap<String, String>();
        Level[] levelArray = new Level[]{Level.ALL, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.INFO, Level.SEVERE, Level.WARNING};
        int n = levelArray.length;
        int n2 = 0;
        while (n2 < n) {
            Level l = levelArray[n2];
            String name = l.getName();
            this.localizedLevels.put(name, this.getLocalized(name, logBundle, logLocale));
            ++n2;
        }
    }

    private Locale getLogLocale() {
        String language = System.getProperty("user.language");
        if (language != null) {
            return new Locale(language, System.getProperty("user.country", ""), System.getProperty("user.variant", ""));
        }
        return Locale.getDefault();
    }

    private String getLogBundle() {
        return Level.INFO.getResourceBundleName();
    }

    private String getLocalized(String text, String logBundleName, Locale logLocale) {
        ResourceBundle bundle = ResourceBundle.getBundle(logBundleName, logLocale);
        String localized = bundle.getString(text);
        return localized;
    }

    @Override
    public String resolve(String level) {
        String localizedLevel = this.localizedLevels.get(level);
        return localizedLevel != null ? localizedLevel : level;
    }
}

