/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.log;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import org.eclipse.glassfish.tools.log.ILogFilter;
import org.eclipse.glassfish.tools.sdk.server.FetchLog;
import org.eclipse.ui.console.MessageConsoleStream;

public class LogReader
implements Runnable {
    private FetchLog logFetcher;
    private MessageConsoleStream output;
    private CountDownLatch latch;
    private ILogFilter filter;

    LogReader(FetchLog logFetcher, MessageConsoleStream outputStream, CountDownLatch latch, ILogFilter filter) {
        this.logFetcher = logFetcher;
        this.output = outputStream;
        this.latch = latch;
        this.filter = filter;
    }

    @Override
    public void run() {
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.logFetcher.getInputStream(), StandardCharsets.UTF_8));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if ((line = this.filter.process(line)) == null) continue;
                    this.output.println(line);
                }
                this.output.flush();
            }
            catch (IOException iOException) {
                this.logFetcher.close();
                this.latch.countDown();
            }
        }
        finally {
            this.logFetcher.close();
            this.latch.countDown();
        }
    }

    public void stop() {
        this.logFetcher.close();
    }
}

