/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.log;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.eclipse.glassfish.tools.log.AbstractLogFilter;
import org.eclipse.glassfish.tools.log.PatternLogFilterV4;

public class StateLogFilterV3
extends AbstractLogFilter {
    private int state;

    StateLogFilterV3() {
    }

    @Override
    public String process(String line) {
        if (line.equals(this.logRecordDelimeter) && !this.isReadingUserMessage()) {
            this.reset();
        }
        String result = null;
        char[] cArray = line.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            result = this.process(c);
            ++n2;
        }
        this.process('\n');
        return result;
    }

    public String process(char c) {
        String result = null;
        switch (this.state) {
            case 0: {
                if (c == '[') {
                    this.state = 1;
                    break;
                }
                if (c == '\n') {
                    if (this.buffer.length() <= 0) break;
                    this.buffer.append(c);
                    result = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                if (c == '\r') break;
                this.buffer.append(c);
                break;
            }
            case 1: {
                if (c == '#') {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                if (c == '\n') {
                    if (this.buffer.length() <= 0) break;
                    this.buffer.append(c);
                    result = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                if (c == '\r') break;
                this.buffer.append('[');
                this.buffer.append(c);
                break;
            }
            case 2: {
                if (c == '|') {
                    this.state = 3;
                    this.buffer.setLength(0);
                    break;
                }
                if (c == '\n') {
                    if (this.buffer.length() <= 0) break;
                    this.buffer.append(c);
                    result = this.buffer.toString();
                    this.buffer.setLength(0);
                    break;
                }
                if (c == '\r') break;
                this.state = 0;
                this.buffer.append('[');
                this.buffer.append('#');
                this.buffer.append(c);
                break;
            }
            case 3: {
                if (c == '|') {
                    this.state = 4;
                    this.record.setTime(this.buffer.toString());
                    this.buffer.setLength(0);
                    break;
                }
                this.buffer.append(c);
                break;
            }
            case 4: {
                if (c == '|') {
                    this.state = 5;
                    this.record.setLevel(this.levelResolver.resolve(this.buffer.toString()));
                    this.buffer.setLength(0);
                    break;
                }
                this.buffer.append(c);
                break;
            }
            case 5: {
                if (c == '|') {
                    this.state = 6;
                    this.record.setVersion(this.buffer.toString());
                    this.buffer.setLength(0);
                    break;
                }
                this.buffer.append(c);
                break;
            }
            case 6: {
                if (c == '|') {
                    this.state = 7;
                    this.record.setClassInfo(this.buffer.toString());
                    this.buffer.setLength(0);
                    break;
                }
                this.buffer.append(c);
                break;
            }
            case 7: {
                if (c == '|') {
                    this.state = 8;
                    this.record.setThreadInfo(this.buffer.toString());
                    this.buffer.setLength(0);
                    break;
                }
                this.buffer.append(c);
                break;
            }
            case 8: {
                if (c == '|') {
                    this.state = 9;
                    this.record.setMessage(this.buffer.toString());
                    break;
                }
                if (c == '\n') {
                    if (this.buffer.length() <= 0) break;
                    this.buffer.append('\n');
                    break;
                }
                if (c == '\r') break;
                this.buffer.append(c);
                break;
            }
            case 9: {
                if (c == '#') {
                    this.state = 10;
                    break;
                }
                this.state = 8;
                this.buffer.append('|');
                this.buffer.append(c);
                break;
            }
            case 10: {
                if (c == ']') {
                    this.state = 0;
                    result = this.formatter.formatLogRecord(this.record);
                    this.reset();
                    break;
                }
                this.state = 8;
                this.buffer.append('|');
                this.buffer.append('#');
                this.buffer.append(c);
            }
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        FileInputStream stream = new FileInputStream("src/oracle/eclipse/tools/glassfish/log/logv4.txt");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            PatternLogFilterV4 filter = new PatternLogFilterV4();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = filter.process(line)) == null) continue;
                System.out.println(line);
            }
            reader.close();
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
    }

    @Override
    protected boolean isReadingUserMessage() {
        return this.state == 8;
    }
}

