/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk;

import java.util.HashMap;
import java.util.Map;

public enum TaskState {
    READY,
    RUNNING,
    COMPLETED,
    FAILED;

    private static final String READY_STR = "READY";
    private static final String RUNNING_STR = "RUNNING";
    private static final String COMPLETED_STR = "COMPLETED";
    private static final String FAILED_STR = "FAILED";
    private static final Map<String, TaskState> stringValuesMap;

    static {
        stringValuesMap = new HashMap<String, TaskState>(TaskState.values().length);
        TaskState[] taskStateArray = TaskState.values();
        int n = taskStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            TaskState state = taskStateArray[n2];
            stringValuesMap.put(state.toString().toUpperCase(), state);
            ++n2;
        }
    }

    public static TaskState toValue(String stateStr) {
        if (stateStr != null) {
            return stringValuesMap.get(stateStr.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case READY: {
                return READY_STR;
            }
            case RUNNING: {
                return RUNNING_STR;
            }
            case COMPLETED: {
                return COMPLETED_STR;
            }
            case FAILED: {
                return FAILED_STR;
            }
        }
        return null;
    }
}

