/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.AdminFactoryHttp;
import org.eclipse.glassfish.tools.sdk.admin.AdminFactoryRest;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.Runner;
import org.eclipse.glassfish.tools.sdk.data.GlassFishAdminInterface;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.sapphire.Version;

public abstract class AdminFactory {
    private static final Logger LOGGER = new Logger(AdminFactory.class);

    static AdminFactory getInstance(Version version) throws CommandException {
        return AdminFactoryRest.getInstance();
    }

    public static AdminFactory getInstance(GlassFishAdminInterface adminInterface) throws CommandException {
        switch (adminInterface) {
            case REST: {
                return AdminFactoryRest.getInstance();
            }
            case HTTP: {
                return AdminFactoryHttp.getInstance();
            }
        }
        throw new CommandException("Unknown GlassFish administration interface type");
    }

    public abstract Runner getRunner(GlassFishServer var1, Command var2);

    Runner newRunner(GlassFishServer srv, Command cmd, Class runnerClass) throws CommandException {
        Constructor con = null;
        Runner runner = null;
        try {
            con = runnerClass.getConstructor(GlassFishServer.class, Command.class);
        }
        catch (NoSuchMethodException | SecurityException nsme) {
            throw new CommandException("Cannot initialize Runner class", nsme);
        }
        if (con == null) {
            return runner;
        }
        try {
            runner = (Runner)con.newInstance(new Object[]{srv, cmd});
        }
        catch (IllegalAccessException | InstantiationException ie) {
            throw new CommandException("Cannot initialize Runner class", ie);
        }
        catch (InvocationTargetException ite) {
            LOGGER.log(Level.WARNING, "exceptionMsg", ite.getMessage());
            Throwable t = ite.getCause();
            if (t != null) {
                LOGGER.log(Level.WARNING, "cause", t.getMessage());
            }
            throw new CommandException("Cannot initialize Runner class", ite);
        }
        return runner;
    }
}

