/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.CommandTarget;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpAddResources;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestAddResources;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpAddResources.class)
@RunnerRestClass(runner=RunnerRestAddResources.class)
public class CommandAddResources
extends CommandTarget {
    private static final Logger LOGGER = new Logger(CommandAddResources.class);
    private static final String COMMAND = "add-resources";
    File xmlResFile;

    public static ResultString addResource(GlassFishServer server, File xmlResourceFile, String target) throws GlassFishIdeException {
        CommandAddResources command = new CommandAddResources(xmlResourceFile, target);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(LOGGER.excMsg("addResource", "exception"), ie);
        }
    }

    public static ResultString addResource(GlassFishServer server, File xmlResourceFile, String target, long timeout) throws GlassFishIdeException {
        CommandAddResources command = new CommandAddResources(xmlResourceFile, target);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(LOGGER.excMsg("addResource", "exception"), ie);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException(LOGGER.excMsg("addResource", "exceptionWithTimeout", Long.toString(timeout)), te);
        }
    }

    public CommandAddResources(File xmlResourceFile, String target) {
        super(COMMAND, target);
        this.xmlResFile = xmlResourceFile;
    }
}

