/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpCreateJDBCConnectionPool;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestCreateJDBCConnectionPool;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;

@RunnerHttpClass(runner=RunnerHttpCreateJDBCConnectionPool.class)
@RunnerRestClass(runner=RunnerRestCreateJDBCConnectionPool.class)
public class CommandCreateJDBCConnectionPool
extends Command {
    private static final String COMMAND = "create-jdbc-connection-pool";
    private static final String ERROR_MESSAGE = "Create JDBC connection pool failed.";
    final String connectionPoolId;
    final String dataSourceClassName;
    final String resType;
    final Map<String, String> properties;

    public static ResultString createJDBCConnectionPool(GlassFishServer server, String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties) throws GlassFishIdeException {
        CommandCreateJDBCConnectionPool command = new CommandCreateJDBCConnectionPool(connectionPoolId, dataSourceClassName, resType, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
    }

    public static ResultString createJDBCConnectionPool(GlassFishServer server, String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties, long timeout) throws GlassFishIdeException {
        CommandCreateJDBCConnectionPool command = new CommandCreateJDBCConnectionPool(connectionPoolId, dataSourceClassName, resType, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException("Create JDBC connection pool failed. in " + timeout + "ms", te);
        }
    }

    public CommandCreateJDBCConnectionPool(String connectionPoolId, String dataSourceClassName, String resType, Map<String, String> properties) {
        super(COMMAND);
        this.connectionPoolId = connectionPoolId;
        this.dataSourceClassName = dataSourceClassName;
        this.resType = resType;
        this.properties = properties;
    }
}

