/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpCreateJDBCResource;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestCreateJDBCResource;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;

@RunnerHttpClass(runner=RunnerHttpCreateJDBCResource.class)
@RunnerRestClass(runner=RunnerRestCreateJDBCResource.class)
public class CommandCreateJDBCResource
extends Command {
    private static final String COMMAND = "create-jdbc-resource";
    private static final String ERROR_MESSAGE = "Create JDBC resource failed.";
    final String connectionPoolId;
    final String jndiName;
    final String target;
    final Map<String, String> properties;

    public static ResultString createJDBCResource(GlassFishServer server, String connectionPoolId, String jndiName, String target, Map<String, String> properties) throws GlassFishIdeException {
        CommandCreateJDBCResource command = new CommandCreateJDBCResource(connectionPoolId, jndiName, target, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
    }

    public static ResultString createJDBCResource(GlassFishServer server, String connectionPoolId, String jndiName, String target, Map<String, String> properties, long timeout) throws GlassFishIdeException {
        CommandCreateJDBCResource command = new CommandCreateJDBCResource(connectionPoolId, jndiName, target, properties);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException("Create JDBC resource failed. in " + timeout + "ms", te);
        }
    }

    public CommandCreateJDBCResource(String connectionPoolId, String jndiName, String target, Map<String, String> properties) {
        super(COMMAND);
        this.connectionPoolId = connectionPoolId;
        this.jndiName = jndiName;
        this.target = target;
        this.properties = properties;
    }
}

