/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpGetProperty.class)
@RunnerRestClass(runner=RunnerRestGetProperty.class)
public class CommandGetProperty
extends Command {
    private static final Logger LOGGER = new Logger(CommandGetProperty.class);
    private static final String COMMAND = "get";
    String propertyPattern;

    public static ResultMap<String, String> getProperties(GlassFishServer server, String propertyPattern) throws GlassFishIdeException {
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
    }

    public static ResultMap<String, String> getProperties(GlassFishServer server, String propertyPattern, long timeout) throws GlassFishIdeException {
        Future future = ServerAdmin.exec(server, new CommandGetProperty(propertyPattern));
        try {
            return (ResultMap)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exception", propertyPattern), ee);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException(LOGGER.excMsg("getProperties", "exceptionWithTimeout", propertyPattern, Long.toString(timeout)), te);
        }
    }

    public CommandGetProperty(String property) {
        super(COMMAND);
        this.propertyPattern = property;
    }
}

