/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.CommandTarget;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpListComponents;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestListApplications;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;

@RunnerHttpClass(runner=RunnerHttpListComponents.class)
@RunnerRestClass(runner=RunnerRestListApplications.class, command="list-applications")
public class CommandListComponents
extends CommandTarget {
    private static final String COMMAND = "list-components";
    private static final String ERROR_MESSAGE = "List components failed.";

    public static ResultMap<String, List<String>> listComponents(GlassFishServer server, String target) throws GlassFishIdeException {
        CommandListComponents command = new CommandListComponents(target);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultMap)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
    }

    public CommandListComponents(String target) {
        super(COMMAND, target);
    }
}

