/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.CommandTarget;
import org.eclipse.glassfish.tools.sdk.admin.ResultList;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpListResources;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestListResources;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

@RunnerHttpClass(runner=RunnerHttpListResources.class)
@RunnerRestClass(runner=RunnerRestListResources.class)
public class CommandListResources
extends CommandTarget {
    private static final Logger LOGGER = new Logger(CommandListResources.class);
    private static final String COMMAND_PREFIX = "list-";
    private static final String COMMAND_SUFFIX = "s";

    public static ResultList<String> listResources(GlassFishServer server, String cmdSuffix, String target) throws GlassFishIdeException {
        CommandListResources command = new CommandListResources(CommandListResources.command(cmdSuffix), target);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultList)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(LOGGER.excMsg("listResources", "exception"), ie);
        }
    }

    public static String command(String resourceCmdSuffix) {
        StringBuilder sb = new StringBuilder(COMMAND_PREFIX.length() + COMMAND_SUFFIX.length() + resourceCmdSuffix.length());
        sb.append(COMMAND_PREFIX);
        sb.append(resourceCmdSuffix);
        sb.append(COMMAND_SUFFIX);
        return sb.toString();
    }

    public CommandListResources(String command, String target) {
        super(command, target);
    }
}

