/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.File;
import java.net.URI;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpLocation;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestLocation;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;

@RunnerHttpClass(runner=RunnerHttpLocation.class)
@RunnerRestClass(runner=RunnerRestLocation.class)
public class CommandLocation
extends Command {
    private static final String COMMAND = "__locations";
    public static final String DOMAIN_ROOT_RESULT_KEY = "Domain-Root_value";
    public static final String BASIC_ROOT_RESULT_KEY = "Base-Root_value";

    public static boolean verifyResult(ResultMap<String, String> resultMap, GlassFishServer server) {
        if (!server.isRemote()) {
            boolean result = false;
            String domainRootResult = (String)resultMap.getValue().get(DOMAIN_ROOT_RESULT_KEY);
            String domainRootServer = ServerUtils.getDomainPath(server);
            if (domainRootResult != null && domainRootServer != null) {
                URI rootResult = new File(domainRootResult).toURI().normalize();
                URI rootServer = new File(domainRootServer).toURI().normalize();
                if (rootResult != null && rootServer != null) {
                    result = rootServer.equals(rootResult);
                }
            }
            return result;
        }
        return true;
    }

    public CommandLocation() {
        super(COMMAND);
    }
}

