/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpRestartDAS;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;

@RunnerHttpClass(runner=RunnerHttpRestartDAS.class)
@RunnerRestClass(command="restart")
public class CommandRestartDAS
extends Command {
    private static final String COMMAND = "restart-domain";
    private static final String ERROR_MESSAGE = "DAS restart failed.";
    final boolean debug;

    public static ResultString restartDAS(GlassFishServer server, boolean debug) throws GlassFishIdeException {
        CommandRestartDAS command = new CommandRestartDAS(debug);
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ie) {
            throw new GlassFishIdeException(ERROR_MESSAGE, ie);
        }
    }

    public CommandRestartDAS(boolean debug) {
        super(COMMAND);
        this.debug = debug;
    }
}

