/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpSetProperty;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestSetProperty;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;

@RunnerHttpClass(runner=RunnerHttpSetProperty.class)
@RunnerRestClass(runner=RunnerRestSetProperty.class)
public class CommandSetProperty
extends Command {
    private static final String COMMAND = "set";
    private static final String ERROR_MESSAGE_PREFIX = "Could not set value ";
    private static final String ERROR_MESSAGE_MIDDLE = " of property ";
    final String property;
    final String value;
    final String format;

    private static String errorMessage(CommandSetProperty command) {
        int valueLen = command.value != null ? command.value.length() : 0;
        int propertyLen = command.property != null ? command.property.length() : 0;
        StringBuilder sb = new StringBuilder(ERROR_MESSAGE_PREFIX.length() + ERROR_MESSAGE_MIDDLE.length() + valueLen + propertyLen);
        sb.append(ERROR_MESSAGE_PREFIX);
        sb.append(valueLen > 0 ? command.value : "");
        sb.append(ERROR_MESSAGE_MIDDLE);
        sb.append(propertyLen > 0 ? command.property : "");
        return sb.toString();
    }

    public static ResultString setProperty(GlassFishServer server, CommandSetProperty command) throws GlassFishIdeException {
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(CommandSetProperty.errorMessage(command), ee);
        }
    }

    public static ResultString setProperty(GlassFishServer server, CommandSetProperty command, long timeout) throws GlassFishIdeException {
        Future future = ServerAdmin.exec(server, command);
        try {
            return (ResultString)future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new GlassFishIdeException(CommandSetProperty.errorMessage(command), ee);
        }
        catch (TimeoutException te) {
            throw new GlassFishIdeException(String.valueOf(CommandSetProperty.errorMessage(command)) + " in " + timeout + "ms", te);
        }
    }

    public CommandSetProperty(String property, String value, String format) {
        super(COMMAND);
        this.property = property;
        this.value = value;
        this.format = format;
    }

    public CommandSetProperty(String property, String value) {
        super(COMMAND);
        this.property = property;
        this.value = value;
        this.format = "DEFAULT={0}={1}";
    }

    public String getProperty() {
        return this.property;
    }

    public String getValue() {
        return this.value;
    }
}

