/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttpClass;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRestClass;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;
import org.eclipse.sapphire.Version;

@RunnerHttpClass
@RunnerRestClass
public class CommandVersion
extends Command {
    private static final Logger LOGGER = new Logger(CommandVersion.class);
    private static final String COMMAND = "version";

    public static ResultString getVersion(GlassFishServer server) throws GlassFishIdeException {
        Future future = ServerAdmin.exec(server, new CommandVersion());
        try {
            return (ResultString)future.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException ee) {
            throw new CommandException(LOGGER.excMsg("getVersion", "exception"), ee.getLocalizedMessage());
        }
    }

    public static Version getGlassFishVersion(GlassFishServer server) {
        String value;
        ResultString result;
        try {
            result = CommandVersion.getVersion(server);
        }
        catch (CommandException commandException) {
            return null;
        }
        String string = value = result != null ? ServerUtils.getVersionString(result.getValue()) : null;
        if (value != null) {
            return new Version(value);
        }
        return null;
    }

    public static boolean verifyResult(ResultString result, GlassFishServer server) {
        boolean verifyResult = false;
        String value = ServerUtils.getVersionString(result.getValue());
        if (value != null) {
            Version valueVersion = new Version(value);
            Version serverVersion = server.getVersion();
            if (valueVersion != null && serverVersion != null) {
                verifyResult = serverVersion.equals((Object)valueVersion);
            }
        }
        return verifyResult;
    }

    public CommandVersion() {
        super(COMMAND);
    }
}

