/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;

public class PasswordFile {
    private static final Logger LOGGER = new Logger(PasswordFile.class);
    public static final String PASSWORD_FILE_NAME = "password-file";
    private static final Set<PosixFilePermission> CREATE_FILE_PERMISSIONS = new HashSet<PosixFilePermission>();
    private static final Set<PosixFilePermission> FINAL_FILE_PERMISSIONS;
    private static final char ASSIGN_VALUE = '=';
    private static final String AS_ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private static final String AS_ADMIN_MASTERPASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private static final String AS_ADMIN_NEWPASSWORD = "AS_ADMIN_NEWPASSWORD";
    Path file;
    private String adminPassword;
    private String masterPassword;
    private String adminNewPassword;

    static {
        CREATE_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
        CREATE_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_WRITE);
        FINAL_FILE_PERMISSIONS = new HashSet<PosixFilePermission>();
        FINAL_FILE_PERMISSIONS.add(PosixFilePermission.OWNER_READ);
    }

    public static Path buildPasswordFilePath(GlassFishServer server) {
        String domainsFolder = server.getDomainsFolder();
        String domainName = server.getDomainName();
        if (domainsFolder == null || domainName == null) {
            throw new CommandException(LOGGER.excMsg("buildPasswordFilePath", "nullValue"));
        }
        return Paths.get(domainsFolder, domainName, "config", PASSWORD_FILE_NAME);
    }

    PasswordFile(GlassFishServer server) {
        this.file = PasswordFile.buildPasswordFilePath(server);
        this.adminPassword = server.getAdminPassword();
        this.masterPassword = null;
        this.adminNewPassword = null;
    }

    public String getFilePath() {
        return this.file.toString();
    }

    public String getAdminPassword() {
        return this.adminPassword;
    }

    public void setAdminPassword(String adminPassword) {
        this.adminPassword = adminPassword;
    }

    public String getMasterPassword() {
        return this.masterPassword;
    }

    public void setMasterPassword(String masterPassword) {
        this.masterPassword = masterPassword;
    }

    public String getAdminNewPassword() {
        return this.adminNewPassword;
    }

    public void setAdminNewPassword(String adminNewPassword) {
        this.adminNewPassword = adminNewPassword;
    }

    private String dataToWrite() {
        int len = AS_ADMIN_PASSWORD.length() + 1 + this.adminPassword.length();
        if (this.masterPassword != null) {
            len += AS_ADMIN_MASTERPASSWORD.length() + 1 + this.masterPassword.length();
        }
        if (this.adminNewPassword != null) {
            len += AS_ADMIN_NEWPASSWORD.length() + 1 + this.adminNewPassword.length();
        }
        StringBuilder sb = new StringBuilder(len);
        sb.append(AS_ADMIN_PASSWORD).append('=');
        sb.append(this.adminPassword).append(OsUtils.LINES_SEPARATOR);
        if (this.masterPassword != null) {
            sb.append(AS_ADMIN_MASTERPASSWORD).append('=');
            sb.append(this.masterPassword).append(OsUtils.LINES_SEPARATOR);
        }
        if (this.adminNewPassword != null) {
            sb.append(AS_ADMIN_NEWPASSWORD).append('=');
            sb.append(this.adminNewPassword).append(OsUtils.LINES_SEPARATOR);
        }
        return sb.toString();
    }

    private boolean createFilePosix() {
        boolean success = false;
        try {
            if (Files.notExists(this.file, new LinkOption[0])) {
                Files.createFile(this.file, PosixFilePermissions.asFileAttribute(CREATE_FILE_PERMISSIONS));
                success = true;
            } else {
                Files.setPosixFilePermissions(this.file, CREATE_FILE_PERMISSIONS);
                LOGGER.log(Level.INFO, "createFilePosix", "exists", this.file.toString());
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.INFO, "createFilePosix", "unsupported", this.file.toString());
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            LOGGER.log(Level.INFO, "createFilePosix", "exists", this.file.toString());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "createFilePosix", "ioException", ioe);
        }
        return success;
    }

    private boolean finishFilePosix() {
        boolean success = false;
        try {
            Files.setPosixFilePermissions(this.file, FINAL_FILE_PERMISSIONS);
            success = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.log(Level.INFO, "finishFilePosix", "unsupported", this.file.toString());
        }
        catch (IOException ioe) {
            LOGGER.log(Level.INFO, "finishFilePosix", "ioException", ioe);
        }
        return success;
    }

    public boolean write() {
        boolean success;
        block14: {
            if (this.adminPassword == null) {
                this.adminPassword = "";
            }
            success = true;
            Writer out = null;
            this.createFilePosix();
            try {
                try {
                    out = new FileWriter(this.file.toFile());
                    out.write(this.dataToWrite());
                }
                catch (IOException ioe) {
                    success = false;
                    LOGGER.log(Level.INFO, "write", "writeException", new Object[]{this.file.toString(), ioe.getMessage()});
                    if (out == null) break block14;
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        success = false;
                        LOGGER.log(Level.INFO, "write", "closeException", this.file.toString());
                    }
                    this.finishFilePosix();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        success = false;
                        LOGGER.log(Level.INFO, "write", "closeException", this.file.toString());
                    }
                    this.finishFilePosix();
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    success = false;
                    LOGGER.log(Level.INFO, "write", "closeException", this.file.toString());
                }
                this.finishFilePosix();
            }
        }
        return success;
    }
}

