/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskEvent;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.PasswordFile;
import org.eclipse.glassfish.tools.sdk.admin.ProcessIOContent;
import org.eclipse.glassfish.tools.sdk.admin.ProcessIOParser;
import org.eclipse.glassfish.tools.sdk.admin.ProcessIOResult;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.RunnerJava;
import org.eclipse.glassfish.tools.sdk.data.ToolConfig;
import org.eclipse.glassfish.tools.sdk.data.ToolsConfig;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;

public abstract class RunnerAsadmin
extends RunnerJava {
    private static final Logger LOGGER = new Logger(RunnerAsadmin.class);
    private static final String USER_PARAM = "--user";
    private static final String PASSWORD_FILE_PARAM = "--passwordfile";
    protected ResultString result;
    private final String asadminJar;
    protected Writer stdIn;
    protected Reader stdOut;
    protected Reader stdErr;
    protected ProcessIOContent processIO;
    protected PasswordFile passwordFile;

    private static String extractPath(GlassFishServer server) {
        ToolsConfig toolsConfig = RunnerAsadmin.getServerConfig(server).getTools();
        if (toolsConfig == null) {
            throw new CommandException(LOGGER.excMsg("extractPath", "noToolsConfig"), server.getVersion());
        }
        ToolConfig asadmin = toolsConfig.getAsadmin();
        if (asadmin == null) {
            throw new CommandException(LOGGER.excMsg("extractPath", "noAsadminConfig"), server.getVersion());
        }
        String serverHome = server.getServerHome();
        String asadminJar = asadmin.getJar();
        StringBuilder sb = new StringBuilder(serverHome.length() + OsUtils.FILE_SEPARATOR_LENGTH + asadminJar.length());
        sb.append(serverHome);
        ServerUtils.addPathElement(sb, asadminJar);
        return sb.toString();
    }

    protected abstract ProcessIOContent createProcessIOContent();

    public RunnerAsadmin(GlassFishServer server, Command command, String query) {
        super(server, command, query);
        this.asadminJar = RunnerAsadmin.extractPath(server);
        this.stdIn = null;
        this.stdOut = null;
        this.stdErr = null;
        this.passwordFile = new PasswordFile(server);
    }

    @Override
    protected Result createResult() {
        this.result = new ResultString();
        return this.result;
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        return false;
    }

    @Override
    protected boolean processResponse() {
        return false;
    }

    String buildProcessArgs() {
        String user = this.server.getAdminUser();
        String passwordFilePath = this.passwordFile.getFilePath();
        StringBuilder sb = new StringBuilder("-jar".length() + 1 + this.asadminJar.length() + 1 + USER_PARAM.length() + 1 + user.length() + 1 + PASSWORD_FILE_PARAM.length() + 1 + passwordFilePath.length() + 1 + this.command.command.length() + 1 + this.query.length());
        sb.append("-jar");
        sb.append(' ');
        sb.append(this.asadminJar);
        sb.append(' ');
        sb.append(USER_PARAM);
        sb.append(' ');
        sb.append(user);
        sb.append(' ');
        sb.append(PASSWORD_FILE_PARAM);
        sb.append(' ');
        sb.append(passwordFilePath);
        sb.append(' ');
        sb.append(this.command.command);
        sb.append(' ');
        sb.append(this.query);
        return sb.toString();
    }

    @Override
    Future<? extends Result> execute() {
        this.processIO = this.createProcessIOContent();
        return super.execute();
    }

    @Override
    Future<? extends Result> execute(ExecutorService executor) {
        this.processIO = this.createProcessIOContent();
        return super.execute(executor);
    }

    @Override
    public Result call() {
        ProcessIOResult verifyResult;
        Process process;
        if (!this.verifyJavaVM()) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.NO_JAVA_VM, this.command.getCommand(), this.server.getName());
        }
        this.passwordFile.write();
        String[] args = OsUtils.parseParameters(this.javaVMExe, this.buildProcessArgs());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        this.setProcessCurrentDir(pb);
        RunnerAsadmin.setJavaEnvironment(pb.environment(), this.command);
        try {
            process = pb.start();
        }
        catch (IOException iOException) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.JAVA_VM_EXEC_FAILED, this.command.getCommand(), this.server.getName());
        }
        ProcessIOParser parser = new ProcessIOParser(new OutputStreamWriter(process.getOutputStream()), new InputStreamReader(process.getInputStream()), this.processIO);
        try {
            verifyResult = parser.verify();
            this.result.value = parser.getOutput();
        }
        catch (IOException iOException) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.EXCEPTION, this.command.getCommand(), this.server.getName());
        }
        switch (verifyResult) {
            case SUCCESS: {
                return this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.command.getCommand(), this.server.getName());
            }
        }
        return this.handleStateChange(TaskState.FAILED, TaskEvent.CMD_FAILED, this.command.getCommand(), this.server.getName());
    }
}

