/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandChangeAdminPassword;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.ProcessIOContent;
import org.eclipse.glassfish.tools.sdk.admin.RunnerAsadmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;

public class RunnerAsadminChangeAdminPassword
extends RunnerAsadmin {
    private static final Logger LOGGER = new Logger(RunnerAsadminChangeAdminPassword.class);
    private static final String DOMAIN_NAME_PARAM = "--domain_name";
    private static final String DOMAINDIR_PARAM = "--domaindir";
    final CommandChangeAdminPassword command;

    private static String query(GlassFishServer server, Command command) {
        String domainsFolder = OsUtils.escapeString(server.getDomainsFolder());
        String domainName = OsUtils.escapeString(server.getDomainName());
        if (domainName == null || domainsFolder == null) {
            throw new CommandException(LOGGER.excMsg("query", "nullValue"));
        }
        StringBuilder sb = new StringBuilder(DOMAIN_NAME_PARAM.length() + 1 + domainName.length() + 1 + DOMAINDIR_PARAM.length() + 1 + domainsFolder.length());
        sb.append(DOMAINDIR_PARAM);
        sb.append(' ');
        sb.append(domainsFolder);
        sb.append(' ');
        sb.append(DOMAIN_NAME_PARAM);
        sb.append(' ');
        sb.append(domainName);
        return sb.toString();
    }

    public RunnerAsadminChangeAdminPassword(GlassFishServer server, Command command) {
        super(server, command, RunnerAsadminChangeAdminPassword.query(server, command));
        if (!(command instanceof CommandChangeAdminPassword)) {
            throw new CommandException(LOGGER.excMsg("init", "illegalInstance"));
        }
        this.command = (CommandChangeAdminPassword)command;
        this.passwordFile.setAdminNewPassword(this.command.password);
    }

    @Override
    protected ProcessIOContent createProcessIOContent() {
        ProcessIOContent processIOContent = new ProcessIOContent();
        processIOContent.addOutput(new String[]{"Command", "executed successfully"}, new String[]{"Command change-admin-password failed"});
        return processIOContent;
    }
}

