/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.Runner;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.NetUtils;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;

public class RunnerHttp
extends Runner {
    static final char LIBRARY_SEPARATOR = ',';
    Manifest manifest;
    ResultString result;

    static int queryPropertiesLength(Map<String, String> properties, String paramName) {
        int propertyLength = 0;
        if (properties != null && properties.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = properties.entrySet();
            boolean first = true;
            propertyLength += paramName.length() + 2;
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (key == null) {
                    throw new CommandException("Value shall not be null");
                }
                if (first) {
                    first = false;
                } else {
                    ++propertyLength;
                }
                propertyLength += key.length() + 1 + (val != null ? val.length() : 0);
            }
        }
        return propertyLength;
    }

    static int queryLibrariesLength(File[] libraries, String paramName) {
        int propertyLength = 0;
        if (libraries != null && libraries.length > 0) {
            boolean first = true;
            propertyLength += paramName.length() + 2;
            File[] fileArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                File library = fileArray[n2];
                if (first) {
                    first = false;
                } else {
                    ++propertyLength;
                }
                propertyLength += library.getPath().length();
                ++n2;
            }
        }
        return propertyLength;
    }

    static StringBuilder queryPropertiesAppend(StringBuilder sb, Map<String, String> properties, String paramName, boolean separator) {
        if (properties != null && properties.size() > 0) {
            Set<Map.Entry<String, String>> entrySet = properties.entrySet();
            boolean first = true;
            if (separator) {
                sb.append('&');
            }
            sb.append(paramName).append('=');
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String val = entry.getValue();
                if (first) {
                    first = false;
                } else {
                    sb.append(':');
                }
                sb.append(key);
                sb.append('=');
                if (val == null) continue;
                sb.append(val);
            }
        }
        return sb;
    }

    static StringBuilder queryLibrariesAppend(StringBuilder sb, File[] libraries, String paramName, boolean separator) {
        if (libraries != null && libraries.length > 0) {
            boolean first = true;
            if (separator) {
                sb.append('&');
            }
            sb.append(paramName).append('=');
            File[] fileArray = libraries;
            int n = libraries.length;
            int n2 = 0;
            while (n2 < n) {
                File library = fileArray[n2];
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(library.getPath());
                ++n2;
            }
        }
        return sb;
    }

    private static boolean successExitCode(Manifest manifest) {
        String exitCode = manifest.getMainAttributes().getValue("exit-code");
        return exitCode == null || !"FAILURE".equals(exitCode.toUpperCase(Locale.ENGLISH));
    }

    private static String getHttpListenerProtocol(String hostname, int port, String url) {
        String retVal = "http";
        try {
            if (NetUtils.isSecurePort(hostname, port)) {
                retVal = "https";
            }
        }
        catch (ConnectException ex) {
            Logger.log(Level.INFO, String.valueOf(hostname) + ":" + port + "::" + url, ex);
        }
        catch (SocketException ex) {
            Logger.log(Level.FINE, String.valueOf(hostname) + ":" + port + "::" + url, ex);
        }
        catch (SocketTimeoutException ex) {
            Logger.log(Level.INFO, String.valueOf(hostname) + ":" + port + "::" + url, ex);
        }
        catch (IOException ex) {
            Logger.log(Level.INFO, String.valueOf(hostname) + ":" + port + "::" + url, ex);
        }
        return retVal;
    }

    public RunnerHttp(GlassFishServer server, Command command) {
        this(server, command, null);
    }

    RunnerHttp(GlassFishServer server, Command command, String query) {
        this(server, command, "/__asadmin/", query);
    }

    protected RunnerHttp(GlassFishServer server, Command command, String path, String query) {
        super(server, command, path, query);
        this.silentFailureAllowed = false;
    }

    @Override
    protected Result createResult() {
        this.result = new ResultString();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    protected String constructCommandUrl() throws CommandException {
        URI uri;
        String host = this.server.getHost();
        boolean useAdminPort = !"false".equals(System.getProperty("glassfish.useadminport"));
        int port = useAdminPort ? this.server.getAdminPort() : this.server.getPort();
        String protocol = "http";
        String url = this.server.getUrl();
        String domainsDir = this.server.getDomainsFolder();
        if (url == null) {
            protocol = RunnerHttp.getHttpListenerProtocol(host, port, ":::" + this.command.getCommand() + "?" + this.query);
        } else if (!url.contains("ee6wc")) {
            protocol = RunnerHttp.getHttpListenerProtocol(host, port, String.valueOf(url) + ":::" + this.command.getCommand() + "?" + this.query);
        } else if (url.contains("ee6wc") && (domainsDir == null || "".equals(domainsDir))) {
            protocol = "https";
        }
        try {
            uri = new URI(protocol, null, host, port, String.valueOf(this.path) + this.command.getCommand(), this.query, null);
        }
        catch (URISyntaxException use) {
            throw new CommandException("Cannot build HTTP command URL", use);
        }
        return uri.toASCIIString().replace("+", "%2b");
    }

    @Override
    protected String getRequestMethod() {
        return "GET";
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        boolean readResult;
        this.manifest = new Manifest();
        try {
            Logger.log(Level.FINEST, "Reading response from {0}:{1}", new Object[]{this.server.getHost(), Integer.toString(this.server.getAdminPort())});
            this.manifest.read(in);
        }
        catch (IOException ioe) {
            throw new CommandException("Can not read HTTP response, caught IOException", ioe);
        }
        if (RunnerHttp.successExitCode(this.manifest)) {
            readResult = true;
        } else {
            readResult = false;
            String message = this.getMessage(this.manifest);
            if (message != null) {
                if (message.contains("please wait")) {
                    this.retry = true;
                } else if (message.contains("javax.security.auth.login.LoginException")) {
                    this.auth = false;
                }
            }
        }
        return readResult;
    }

    @Override
    protected boolean processResponse() {
        this.result.value = this.getMessage(this.manifest);
        this.result.auth = this.auth;
        Logger.log(Level.FINEST, "Manifest message: {0}", new Object[]{this.result.value});
        return this.result.value != null;
    }

    public String getLastModified() {
        return null;
    }

    private String getMessage(Manifest manifest) {
        String message = null;
        String tmp = manifest.getMainAttributes().getValue("message");
        if (tmp != null) {
            try {
                message = URLDecoder.decode(ServerUtils.manifestDecode(tmp), "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                Logger.log(Level.WARNING, "Could not URL decode with UTF-8", uee);
            }
            catch (IllegalArgumentException iae) {
                Logger.log(Level.FINE, "Caught IllegalArgumentException", iae);
                message = tmp;
            }
        }
        return message;
    }

    byte[] getExtraProperties() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Properties props = new Properties();
        props.setProperty("data-request-type", "file-xfer");
        props.setProperty("last-modified", this.getLastModified());
        props.put("data-request-name", "DEFAULT");
        props.put("data-request-is-recursive", "true");
        props.put("Content-Type", "application/octet-stream");
        props.list(new PrintStream(baos));
        return baos.toByteArray();
    }

    @Override
    protected void prepareHttpConnection(HttpURLConnection conn) throws CommandException {
        super.prepareHttpConnection(conn);
        String contentType = this.getContentType();
        if (contentType == null || contentType.length() <= 0) {
            conn.setRequestProperty("Content-Type", "image/png");
        }
        conn.setRequestProperty("User-Agent", "hk2-agent");
    }
}

