/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.RunnerHttp;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

public class RunnerHttpGetProperty
extends RunnerHttp {
    private static final Logger LOGGER = new Logger(RunnerHttpGetProperty.class);
    ResultMap<String, String> result;

    public RunnerHttpGetProperty(GlassFishServer server, Command command) {
        super(server, command, "pattern=" + ((CommandGetProperty)command).propertyPattern);
    }

    @Override
    protected ResultMap<String, String> createResult() {
        this.result = new ResultMap<String, String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        if (this.manifest == null) {
            LOGGER.log(Level.WARNING, "processResponse", "manifestNull", this.query);
            return false;
        }
        this.result.value = new HashMap();
        for (String encodedkey : this.manifest.getEntries().keySet()) {
            int equalsIndex;
            String key = "";
            try {
                if (encodedkey != null) {
                    key = encodedkey;
                    key = URLDecoder.decode(encodedkey, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException uee) {
                LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", encodedkey);
                LOGGER.log(Level.INFO, "processResponse", "exceptionDetails", uee);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if ((equalsIndex = key.indexOf(61)) >= 0) {
                String keyPart = key.substring(0, equalsIndex);
                String valuePart = key.substring(equalsIndex + 1);
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.INFO, "processResponse", "illegalArgument", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            LOGGER.log(Level.WARNING, "processResponse", "emptyString", key);
            this.result.value.put(key, "");
        }
        return true;
    }
}

