/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskEvent;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandStartDAS;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.ResultProcess;
import org.eclipse.glassfish.tools.sdk.admin.RunnerJava;
import org.eclipse.glassfish.tools.sdk.admin.ValueProcess;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.JavaUtils;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;
import org.eclipse.glassfish.tools.sdk.utils.Utils;

public class RunnerLocal
extends RunnerJava {
    private static final String MAIN_CLASS = "com.sun.enterprise.glassfish.bootstrap.ASMain";
    final CommandStartDAS command;
    private String arguments;
    ResultProcess result;

    public RunnerLocal(GlassFishServer server, Command command) {
        super(server, command);
        this.command = (CommandStartDAS)command;
    }

    @Override
    protected Result createResult() {
        this.result = new ResultProcess();
        return this.result;
    }

    @Override
    protected boolean readResponse(InputStream in, HttpURLConnection hconn) {
        return false;
    }

    @Override
    protected boolean processResponse() {
        return false;
    }

    private static String buildJavaOptions(GlassFishServer server, CommandStartDAS command) {
        StringBuilder sb = new StringBuilder();
        boolean isClasspath = command.classPath != null && command.classPath.length() > 0;
        boolean isOptions = command.javaOpts != null && command.javaOpts.length() > 0;
        sb.append("-cp").append(' ');
        if (isClasspath) {
            sb.append(command.classPath);
        } else {
            File bootstrapJar = ServerUtils.getJarName(server.getServerHome(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
            sb.append(Utils.quote(bootstrapJar.getAbsolutePath()));
        }
        sb.append(' ');
        if (isOptions) {
            sb.append(command.javaOpts);
            sb.append(' ');
        }
        sb.append(MAIN_CLASS);
        sb.append(' ');
        if (command.glassfishArgs != null && command.glassfishArgs.length() > 0) {
            sb.append(command.glassfishArgs);
        }
        return sb.toString();
    }

    @Override
    void setProcessCurrentDir(ProcessBuilder pb) {
        File currentDir;
        if (this.command.domainDir != null && this.command.domainDir.length() > 0 && (currentDir = new File(ServerUtils.getDomainConfigPath(this.command.domainDir))).exists()) {
            Logger.log(Level.FINEST, "Setting {0} process current directory to {1}", new Object[]{this.server.getName(), this.command.domainDir});
            pb.directory(currentDir);
        }
    }

    @Override
    public Result call() {
        Process process;
        String javaVmExe = JavaUtils.javaVmExecutableFullPath(this.command.javaHome);
        File javaVmFile = new File(javaVmExe);
        if (!javaVmFile.exists()) {
            Logger.log(Level.INFO, "Java VM {0} executable for {1} was not found", new Object[]{javaVmFile.getAbsolutePath(), this.server.getName()});
            return this.handleStateChange(TaskState.FAILED, TaskEvent.NO_JAVA_VM, this.command.getCommand(), this.server.getName());
        }
        JavaUtils.JavaVersion javaVersion = JavaUtils.javaVmVersion(javaVmFile);
        Logger.log(Level.FINEST, "Java VM {0} executable version {1}", new Object[]{javaVmFile.getAbsolutePath(), javaVersion != null ? javaVersion.toString() : "null"});
        if (javaVersion == null || javaVersion.comapreTo(new JavaUtils.JavaVersion(1, 6, 0, 0)) == -1) {
            Logger.log(Level.INFO, "Java VM {0} executable version {1} can't be used with {2} but trying to start server anyway.", new Object[]{javaVmFile.getAbsolutePath(), javaVersion != null ? javaVersion.toString() : "null", this.server.getName()});
        }
        String allArgs = RunnerLocal.buildJavaOptions(this.server, this.command);
        String[] args = OsUtils.parseParameters(javaVmExe, allArgs);
        Logger.log(Level.FINEST, "Starting {0} using Java VM {1} and arguments {2}", new Object[]{this.server.getName(), javaVmExe, allArgs});
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.redirectErrorStream(true);
        this.setProcessCurrentDir(pb);
        RunnerLocal.setJavaEnvironment(pb.environment(), this.command);
        try {
            process = pb.start();
        }
        catch (IOException iOException) {
            return this.handleStateChange(TaskState.FAILED, TaskEvent.JAVA_VM_EXEC_FAILED, this.command.getCommand(), this.server.getName());
        }
        this.result.value = new ValueProcess(javaVmFile.getAbsolutePath(), allArgs, process);
        return this.handleStateChange(TaskState.COMPLETED, TaskEvent.CMD_COMPLETED, this.command.getCommand(), this.server.getName());
    }
}

