/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandException;
import org.eclipse.glassfish.tools.sdk.admin.CommandFetchLogData;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.ResultLog;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRest;
import org.eclipse.glassfish.tools.sdk.admin.ValueLog;
import org.eclipse.glassfish.tools.sdk.admin.response.ResponseContentType;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

public class RunnerRestFetchLogData
extends RunnerRest {
    private List<String> lines;
    private URL headerAppendNext;
    ResultLog result;

    private static String query(Command command) {
        if (command instanceof CommandFetchLogData) {
            return ((CommandFetchLogData)command).paramsAppendNext;
        }
        throw new CommandException("Illegal command instance provided");
    }

    public RunnerRestFetchLogData(GlassFishServer server, Command command) {
        super(server, command, "/management/domain/", RunnerRestFetchLogData.query(command));
    }

    @Override
    protected Result createResult() {
        this.result = new ResultLog();
        return this.result;
    }

    @Override
    public boolean getDoOutput() {
        return false;
    }

    @Override
    protected String getRequestMethod() {
        return "GET";
    }

    @Override
    public boolean acceptsGzip() {
        return false;
    }

    @Override
    public boolean readResponse(InputStream in, HttpURLConnection hconn) {
        this.lines = new LinkedList<String>();
        String ce = hconn.getContentEncoding();
        BufferedReader br = null;
        String line = null;
        try {
            try {
                InputStream cooked = ce != null && ce.contains("gzip") ? new GZIPInputStream(in) : in;
                br = new BufferedReader(new InputStreamReader(cooked));
                while ((line = br.readLine()) != null) {
                    if (line == null) continue;
                    this.lines.add(line);
                }
            }
            catch (IOException ioe) {
                throw new CommandException("Can not read HTTP response, caught IOException", ioe);
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException ioe) {
                Logger.log(Level.WARNING, ioe.getLocalizedMessage(), ioe);
            }
        }
        try {
            this.headerAppendNext = new URL(hconn.getHeaderField("X-Text-Append-Next"));
        }
        catch (MalformedURLException mue) {
            Logger.log(Level.WARNING, mue.getLocalizedMessage(), mue);
            this.headerAppendNext = null;
            return false;
        }
        String queryAppendNext = this.headerAppendNext.getQuery();
        return queryAppendNext != null;
    }

    @Override
    protected boolean processResponse() {
        ArrayList<String> logLines = new ArrayList<String>(this.lines.size());
        for (String line : this.lines) {
            logLines.add(line);
        }
        this.result.value = new ValueLog(logLines, this.headerAppendNext.getQuery());
        return true;
    }

    @Override
    protected ResponseContentType getResponseType() {
        return ResponseContentType.TEXT_PLAIN;
    }
}

