/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.RunnerRest;
import org.eclipse.glassfish.tools.sdk.admin.response.MessagePart;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

public class RunnerRestGetProperty
extends RunnerRest {
    private static final Logger LOGGER = new Logger(RunnerRestGetProperty.class);
    ResultMap<String, String> result;

    public RunnerRestGetProperty(GlassFishServer server, Command command) {
        super(server, command, "/command/", null);
    }

    @Override
    protected ResultMap<String, String> createResult() {
        this.result = new ResultMap<String, String>();
        return this.result;
    }

    @Override
    protected boolean processResponse() {
        List<MessagePart> childMessages = this.report.getTopMessagePart().getChildren();
        if (childMessages == null || childMessages.isEmpty()) {
            return false;
        }
        this.result.value = new HashMap(childMessages.size());
        for (MessagePart msg : childMessages) {
            String message = msg.getMessage();
            int equalsIndex = message.indexOf(61);
            if (equalsIndex >= 0) {
                String keyPart = message.substring(0, equalsIndex);
                String valuePart = message.substring(equalsIndex + 1);
                try {
                    this.result.value.put(keyPart, valuePart);
                    this.result.value.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                    this.result.value.put(keyPart, URLDecoder.decode((String)this.result.value.get(keyPart), "UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOGGER.log(Level.INFO, "processResponse", "unsupportedEncoding", this.result.value.get(keyPart));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    LOGGER.log(Level.INFO, "processResponse", "illegalArgument", new Object[]{valuePart, this.result.value.get(keyPart)});
                }
                continue;
            }
            LOGGER.log(Level.INFO, "processResponse", "emptyString", message);
            this.result.value.put(message, "");
        }
        return true;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter(hconn.getOutputStream());
        CommandGetProperty gpCommand = (CommandGetProperty)this.command;
        StringBuilder data = new StringBuilder();
        data.append("pattern=").append(gpCommand.propertyPattern);
        wr.write(data.toString());
        wr.flush();
        wr.close();
    }
}

