/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin;

import java.net.Authenticator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskStateListener;
import org.eclipse.glassfish.tools.sdk.admin.AdminFactory;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.Runner;
import org.eclipse.glassfish.tools.sdk.data.IdeContext;

public class ServerAdmin {
    public static void init(Authenticator authenticator) {
        Runner.init(authenticator);
    }

    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute();
    }

    public static ExecutorService executor(int size) {
        return Runner.parallelExecutor(size);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd, IdeContext ide) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd, IdeContext ide, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(GlassFishServer srv, Command cmd, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute();
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        return runner.execute(executor);
    }

    public static <E extends Result> Future<E> exec(ExecutorService executor, GlassFishServer srv, Command cmd, TaskStateListener ... listeners) {
        AdminFactory af = AdminFactory.getInstance(srv.getAdminInterface());
        Runner runner = af.getRunner(srv, cmd);
        runner.stateListeners = listeners;
        return runner.execute(executor);
    }
}

