/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.admin.cloud;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.cloud.CommandCloudDeploy;
import org.eclipse.glassfish.tools.sdk.admin.cloud.RunnerRestCloud;

public class RunnerRestCloudDeploy
extends RunnerRestCloud {
    private static final String NEWLINE = "\r\n";
    private String multipartBoundary = Long.toHexString(System.currentTimeMillis());
    final CommandCloudDeploy command;

    public RunnerRestCloudDeploy(GlassFishServer server, Command command) {
        super(server, command);
        this.command = (CommandCloudDeploy)command;
    }

    @Override
    protected void handleSend(HttpURLConnection hconn) throws IOException {
        if (this.command.path == null) {
            throw new GlassFishIdeException("The path attribute of deploy command has to be non-empty!");
        }
        OutputStreamWriter wr = new OutputStreamWriter(hconn.getOutputStream());
        this.writeParam(wr, "file", this.command.path.getAbsolutePath());
        if (this.command.account != null) {
            this.writeParam(wr, "account", this.command.account);
        }
        this.writeBinaryFile(wr, hconn.getOutputStream(), this.command.path);
        wr.append("--" + this.multipartBoundary + "--").append(NEWLINE);
        wr.close();
    }

    private void writeParam(OutputStreamWriter writer, String paramName, String paramValue) throws IOException {
        writer.append("--" + this.multipartBoundary).append(NEWLINE);
        writer.append("Content-Disposition: form-data; name=\"").append(paramName).append("\"").append(NEWLINE);
        writer.append("Content-Type: text/plain;").append(NEWLINE);
        writer.append(NEWLINE);
        writer.append(paramValue).append(NEWLINE).flush();
    }

    private void writeBinaryFile(OutputStreamWriter writer, OutputStream output, File file) throws IOException {
        writer.append("--" + this.multipartBoundary).append(NEWLINE);
        writer.append("Content-Disposition: form-data; name=\"warFile\"; filename=\"" + file.getAbsolutePath() + "\"").append(NEWLINE);
        writer.append("Content-Type: application/octet-stream").append(NEWLINE);
        writer.append("Content-Transfer-Encoding: binary").append(NEWLINE);
        writer.append(NEWLINE).flush();
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] buffer = new byte[0x100000];
            int length = 0;
            while ((length = ((InputStream)input).read(buffer)) > 0) {
                output.write(buffer, 0, length);
            }
            output.flush();
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                ((InputStream)input).close();
            }
            catch (IOException iOException) {}
        }
        writer.append(NEWLINE).flush();
    }
}

