/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.FetchLogException;
import org.eclipse.glassfish.tools.sdk.server.FetchLogPiped;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;

public class FetchLogLocal
extends FetchLogPiped {
    private static final Logger LOGGER = new Logger(FetchLogLocal.class);

    FetchLogLocal(GlassFishServer server, boolean skip) {
        super(server, skip);
    }

    FetchLogLocal(ExecutorService executor, GlassFishServer server, boolean skip) {
        super(executor, server, skip);
    }

    private InputStream initInputFile() {
        FileInputStream log;
        File logFile = ServerUtils.getServerLogFile(this.server);
        try {
            log = new FileInputStream(logFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LOGGER.log(Level.INFO, "initInputFile", "fileNotFound", logFile.getAbsolutePath());
            return null;
        }
        if (this.skip) {
            try {
                int count;
                while ((count = ((InputStream)log).available()) > 0) {
                    ((InputStream)log).skip(count);
                }
            }
            catch (IOException ioe) {
                try {
                    ((InputStream)log).close();
                }
                catch (IOException ioec) {
                    LOGGER.log(Level.INFO, "initInputFile", "cantClose", ioec);
                }
                throw new FetchLogException(LOGGER.excMsg("initInputFile", "cantInit"), ioe);
            }
        }
        return log;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TaskState call() {
        this.notifyListeners(TaskState.RUNNING);
        fIn = this.initInputFile();
        buff = new byte[8192];
        logFile = ServerUtils.getServerLogFile(this.server);
        if (fIn != null) ** GOTO lbl44
        return this.notifyListeners(TaskState.FAILED);
lbl-1000:
        // 1 sources

        {
            try {
                inCount = fIn.available();
                lastModified = logFile.lastModified();
                if (inCount <= 0) {
                    Thread.sleep(1000L);
                    inCount = fIn.available();
                    if (inCount <= 0 && logFile.lastModified() > lastModified) {
                        FetchLogLocal.LOGGER.log(Level.FINER, "call", "rotation");
                        fIn.close();
                        this.out.flush();
                        fIn = this.initInputFile();
                    }
                }
                if (inCount <= 0) continue;
                while (inCount > 0) {
                    count = fIn.read(buff);
                    FetchLogLocal.LOGGER.log(Level.FINEST, "call", "read", new Object[]{new Integer(count)});
                    if (count <= 0) break;
                    this.out.write(buff, 0, count);
                    if ((inCount -= count) > 0) continue;
                    inCount = fIn.available();
                }
                this.out.flush();
                continue;
            }
            catch (InterruptedException ie) {
                FetchLogLocal.LOGGER.log(Level.INFO, "call", "interrupted", ie.getMessage());
                Thread.currentThread().interrupt();
                return this.notifyListeners(TaskState.COMPLETED);
            }
            catch (InterruptedIOException ie) {
                FetchLogLocal.LOGGER.log(Level.INFO, "call", "interruptedIO", ie.getMessage());
                Thread.currentThread().interrupt();
                return this.notifyListeners(TaskState.COMPLETED);
            }
            catch (IOException ioe) {
                if (this.taksExecute) {
                    FetchLogLocal.LOGGER.log(Level.INFO, "call", "ioException", ioe);
                    return this.notifyListeners(TaskState.FAILED);
                }
                FetchLogLocal.LOGGER.log(Level.INFO, "call", "ioExceptionMsg", ioe.getMessage());
                return this.notifyListeners(TaskState.COMPLETED);
            }
lbl44:
            // 3 sources

            ** while (this.taksExecute)
        }
lbl45:
        // 1 sources

        return this.notifyListeners(TaskState.COMPLETED);
    }
}

