/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.FetchLog;
import org.eclipse.glassfish.tools.sdk.server.FetchLogEvent;
import org.eclipse.glassfish.tools.sdk.server.FetchLogEventListener;
import org.eclipse.glassfish.tools.sdk.server.FetchLogException;
import org.eclipse.glassfish.tools.sdk.server.FetchLogLocal;
import org.eclipse.glassfish.tools.sdk.server.FetchLogRemote;
import org.eclipse.glassfish.tools.sdk.utils.LinkedList;
import org.eclipse.glassfish.tools.sdk.utils.NetUtils;

public abstract class FetchLogPiped
extends FetchLog
implements Callable<TaskState> {
    private static final Logger LOGGER = new Logger(FetchLogPiped.class);
    static final int PIPE_BUFFER_SIZE = 8192;
    static final int LOG_REFRESH_DELAY = 1000;
    final PipedOutputStream out;
    Future<TaskState> task;
    private ExecutorService executor;
    private final boolean internalExecutor;
    volatile boolean taksExecute;
    private final LinkedList<FetchLogEventListener> eventListeners = new LinkedList();

    public static FetchLogPiped create(GlassFishServer server, boolean skip) {
        boolean isLocal = NetUtils.isLocahost(server.getHost());
        FetchLogPiped fetchLog = isLocal ? new FetchLogLocal(server, skip) : new FetchLogRemote(server, skip);
        super.start();
        return fetchLog;
    }

    public static FetchLogPiped create(GlassFishServer server) {
        return FetchLogPiped.create(server, false);
    }

    public static FetchLogPiped create(ExecutorService executor, GlassFishServer server, boolean skip) {
        boolean isLocal = NetUtils.isLocahost(server.getHost());
        FetchLogPiped fetchLog = isLocal ? new FetchLogLocal(executor, server, skip) : new FetchLogRemote(executor, server, skip);
        super.start();
        return fetchLog;
    }

    public static FetchLogPiped create(ExecutorService executor, GlassFishServer server) {
        return FetchLogPiped.create(executor, server, false);
    }

    FetchLogPiped(final GlassFishServer server, boolean skip) {
        super(server, skip);
        try {
            this.out = new PipedOutputStream((PipedInputStream)this.in);
        }
        catch (IOException ioe) {
            super.close();
            throw new FetchLogException(LOGGER.excMsg("init", "cantInit"), ioe);
        }
        this.taksExecute = true;
        this.executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, String.valueOf(FetchLogPiped.class.getName()) + server.getUrl() != null ? " (Localhost)" : server.getUrl());
                t.setDaemon(true);
                return t;
            }
        });
        this.internalExecutor = true;
    }

    FetchLogPiped(ExecutorService executor, GlassFishServer server, boolean skip) {
        super(server, skip);
        try {
            this.out = new PipedOutputStream((PipedInputStream)this.in);
        }
        catch (IOException ioe) {
            super.close();
            throw new FetchLogException(LOGGER.excMsg("init", "cantInit"), ioe);
        }
        this.taksExecute = true;
        this.executor = executor;
        this.internalExecutor = false;
    }

    @Override
    InputStream initInputStream() {
        return new PipedInputStream(8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(FetchLogEventListener listener) throws FetchLogException {
        if (listener == null) {
            throw new FetchLogException(LOGGER.excMsg("addListener", "listenerNull"));
        }
        LinkedList<FetchLogEventListener> linkedList = this.eventListeners;
        synchronized (linkedList) {
            this.eventListeners.addLast(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean removeListener(FetchLogEventListener listener) throws FetchLogException {
        if (listener == null) {
            throw new FetchLogException(LOGGER.excMsg("removeListener", "listenerNull"));
        }
        boolean removed = false;
        LinkedList<FetchLogEventListener> linkedList = this.eventListeners;
        synchronized (linkedList) {
            boolean isElement = !this.eventListeners.isEmpty();
            this.eventListeners.first();
            while (isElement) {
                if (listener.equals(this.eventListeners.getCurrent())) {
                    isElement = this.eventListeners.isNext();
                    this.eventListeners.removeAndNextOrPrevious();
                    removed = true;
                    continue;
                }
                isElement = this.eventListeners.next();
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final TaskState notifyListeners(TaskState state) {
        if (!this.eventListeners.isEmpty()) {
            LinkedList<FetchLogEventListener> linkedList = this.eventListeners;
            synchronized (linkedList) {
                boolean isElement;
                boolean bl = isElement = !this.eventListeners.isEmpty();
                if (isElement) {
                    FetchLogEvent event = new FetchLogEvent(state);
                    this.eventListeners.first();
                    while (isElement) {
                        this.eventListeners.getCurrent().stateChanged(event);
                        isElement = this.eventListeners.next();
                    }
                }
            }
        }
        return state;
    }

    private void start() {
        this.task = this.executor.submit(this);
        this.notifyListeners(TaskState.READY);
    }

    private TaskState stop() {
        TaskState result;
        this.taksExecute = false;
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.INFO, "stop", "cantClose", ioe);
            }
        } else {
            LOGGER.log(Level.INFO, "stop", "isNull");
        }
        try {
            result = this.task.get();
        }
        catch (InterruptedException ie) {
            throw new FetchLogException(LOGGER.excMsg("stop", "interrupted"), ie);
        }
        catch (ExecutionException ee) {
            throw new FetchLogException(LOGGER.excMsg("stop", "exception"), ee);
        }
        catch (CancellationException ce) {
            throw new FetchLogException(LOGGER.excMsg("stop", "cancelled"), ce);
        }
        return result;
    }

    @Override
    public void close() {
        TaskState result = this.stop();
        super.close();
        if (this.internalExecutor) {
            this.executor.shutdownNow();
        }
        if (result != TaskState.COMPLETED) {
            LOGGER.log(Level.INFO, "close", "failed");
        }
    }

    public boolean isRunning() {
        return !this.task.isDone();
    }
}

