/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.CommandFetchLogData;
import org.eclipse.glassfish.tools.sdk.admin.ResultLog;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.FetchLogPiped;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;

public class FetchLogRemote
extends FetchLogPiped {
    private static final Logger LOGGER = new Logger(FetchLogPiped.class);

    FetchLogRemote(GlassFishServer server, boolean skip) {
        super(server, skip);
    }

    FetchLogRemote(ExecutorService executor, GlassFishServer server, boolean skip) {
        super(executor, server, skip);
    }

    @Override
    public TaskState call() {
        this.notifyListeners(TaskState.RUNNING);
        String paramsAppendNext = null;
        Future future = ServerAdmin.exec(this.server, new CommandFetchLogData());
        try {
            ResultLog result = (ResultLog)future.get();
            if (!this.skip && result.getState() == TaskState.COMPLETED) {
                paramsAppendNext = result.getValue().getParamsAppendNext();
                for (String line : result.getValue().getLines()) {
                    this.out.write(line.getBytes());
                    this.out.write(OsUtils.LINES_SEPARATOR.getBytes());
                }
                this.out.flush();
            }
            byte[] lineSeparatorOut = OsUtils.LINES_SEPARATOR.getBytes();
            while (this.taksExecute && result.getState() == TaskState.COMPLETED) {
                future = ServerAdmin.exec(this.server, new CommandFetchLogData(paramsAppendNext));
                result = (ResultLog)future.get();
                if (result.getState() == TaskState.COMPLETED) {
                    paramsAppendNext = result.getValue().getParamsAppendNext();
                    for (String line : result.getValue().getLines()) {
                        byte[] lineOut = line.getBytes();
                        LOGGER.log(Level.FINEST, "call", "read", new Object[]{new Integer(lineOut.length + lineSeparatorOut.length)});
                        this.out.write(lineOut);
                        this.out.write(lineSeparatorOut);
                    }
                    this.out.flush();
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, "call", "interrupted", ie.getMessage());
            Thread.currentThread().interrupt();
            return this.notifyListeners(TaskState.COMPLETED);
        }
        catch (ExecutionException ee) {
            LOGGER.log(Level.INFO, "call", "exception", ee);
            return this.notifyListeners(TaskState.FAILED);
        }
        catch (InterruptedIOException ie) {
            LOGGER.log(Level.INFO, "call", "interruptedIO", ie.getMessage());
            Thread.currentThread().interrupt();
            return this.notifyListeners(TaskState.COMPLETED);
        }
        catch (IOException ioe) {
            if (this.taksExecute) {
                LOGGER.log(Level.INFO, "call", "ioException", ioe);
                return this.notifyListeners(TaskState.FAILED);
            }
            LOGGER.log(Level.INFO, "call", "ioExceptionMsg", ioe.getMessage());
            return this.notifyListeners(TaskState.COMPLETED);
        }
        return this.notifyListeners(TaskState.COMPLETED);
    }
}

