/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.admin.CommandStartDAS;
import org.eclipse.glassfish.tools.sdk.admin.ResultProcess;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.data.StartupArgs;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.parser.JvmConfigReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.sdk.utils.JavaUtils;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;
import org.eclipse.glassfish.tools.sdk.utils.Utils;

public class ServerTasks {
    private static final Logger LOGGER = new Logger(ServerTasks.class);
    private static final String DAS_NAME = "server";

    private static Map varMap(GlassFishServer server, String javaHome) {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("com.sun.aas.installRoot", server.getServerHome());
        varMap.put("com.sun.aas.instanceRoot", ServerUtils.getDomainPath(server));
        varMap.put("com.sun.aas.javaRoot", javaHome);
        varMap.put("com.sun.aas.derbyRoot", ServerUtils.getDerbyRoot(server));
        return varMap;
    }

    private static void addJavaAgent(GlassFishServer server, JvmConfigReader jvmConfigReader) {
        List<String> optList = jvmConfigReader.getOptList();
        File serverHome = new File(server.getServerHome());
        File btrace = new File(serverHome, "lib/monitor/btrace-agent.jar");
        File flight = new File(serverHome, "lib/monitor/flashlight-agent.jar");
        if (jvmConfigReader.isMonitoringEnabled()) {
            if (btrace.exists()) {
                optList.add("-javaagent:" + Utils.quote(btrace.getAbsolutePath()) + "=unsafe=true,noServer=true");
            } else if (flight.exists()) {
                optList.add("-javaagent:" + Utils.quote(flight.getAbsolutePath()));
            }
        }
    }

    private static void appendVarMap(StringBuilder javaOpts, Map<String, String> varMap) {
        for (Map.Entry<String, String> entry : varMap.entrySet()) {
            javaOpts.append(' ');
            JavaUtils.systemProperty(javaOpts, entry.getKey(), entry.getValue());
        }
    }

    public static ResultProcess startServer(GlassFishServer server, StartupArgs args, StartMode mode) throws GlassFishIdeException {
        JvmConfigReader jvmConfigReader = new JvmConfigReader(DAS_NAME);
        String domainAbsolutePath = String.valueOf(server.getDomainsFolder()) + File.separator + server.getDomainName();
        String domainXmlPath = String.valueOf(domainAbsolutePath) + File.separator + "config" + File.separator + "domain.xml";
        if (!TreeParser.readXml(new File(domainXmlPath), jvmConfigReader)) {
            throw new GlassFishIdeException(LOGGER.excMsg("startServer", "readXMLerror"), domainXmlPath);
        }
        List<String> optList = jvmConfigReader.getOptList();
        Map<String, String> propMap = jvmConfigReader.getPropMap();
        ServerTasks.addJavaAgent(server, jvmConfigReader);
        File bootstrapJar = ServerUtils.getJarName(server.getServerHome(), "glassfish(?:-[0-9bSNAPHOT]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (bootstrapJar == null) {
            throw new GlassFishIdeException(LOGGER.excMsg("startServer", "noBootstrapJar"));
        }
        String classPath = ServerTasks.computeClassPath(propMap, new File(domainAbsolutePath), bootstrapJar);
        StringBuilder javaOpts = new StringBuilder(1024);
        StringBuilder glassfishArgs = new StringBuilder(256);
        Map varMap = ServerTasks.varMap(server, args.getJavaHome());
        if (mode.equals((Object)StartMode.DEBUG)) {
            String debugOpts = propMap.get("debug-options");
            String[] debugOptsSplited = debugOpts.split("\\s+(?=-)");
            optList.addAll(Arrays.asList(debugOptsSplited));
        }
        mode.equals((Object)StartMode.PROFILE);
        if (args.getJavaArgs() != null) {
            optList.addAll(args.getJavaArgs());
        }
        ServerTasks.appendOptions(javaOpts, optList, varMap);
        ServerTasks.appendVarMap(javaOpts, varMap);
        if (args.getGlassfishArgs() != null) {
            ServerTasks.appendGlassfishArgs(glassfishArgs, args.getGlassfishArgs());
        }
        CommandStartDAS startCommand = new CommandStartDAS(args.getJavaHome(), classPath, javaOpts.toString(), glassfishArgs.toString(), domainAbsolutePath);
        Future future = ServerAdmin.exec(server, startCommand);
        try {
            return (ResultProcess)future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new GlassFishIdeException(LOGGER.excMsg("startServer", "failed"), e);
        }
    }

    public static ResultProcess startServer(GlassFishServer server, StartupArgs args) throws GlassFishIdeException {
        return ServerTasks.startServer(server, args, StartMode.START);
    }

    private static String computeClassPath(Map<String, String> propMap, File domainDir, File bootstrapJar) {
        String result = null;
        List<File> prefixCP = Utils.classPathToFileList(propMap.get("classpath-prefix"), domainDir);
        List<File> suffixCP = Utils.classPathToFileList(propMap.get("classpath-suffix"), domainDir);
        boolean useEnvCP = "false".equals(propMap.get("env-classpath-ignored"));
        List<File> envCP = Utils.classPathToFileList(useEnvCP ? System.getenv("CLASSPATH") : null, domainDir);
        List<File> systemCP = Utils.classPathToFileList(propMap.get("system-classpath"), domainDir);
        if (prefixCP.size() > 0 || suffixCP.size() > 0 || envCP.size() > 0 || systemCP.size() > 0) {
            List<File> mainCP = Utils.classPathToFileList(bootstrapJar.getAbsolutePath(), null);
            if (mainCP.size() > 0) {
                ArrayList<File> completeCP = new ArrayList<File>(32);
                completeCP.addAll(prefixCP);
                completeCP.addAll(mainCP);
                completeCP.addAll(systemCP);
                completeCP.addAll(envCP);
                completeCP.addAll(suffixCP);
                StringBuilder classPath = new StringBuilder(1024);
                Iterator iter = completeCP.iterator();
                classPath.append(Utils.quote(((File)iter.next()).getPath()));
                while (iter.hasNext()) {
                    classPath.append(File.pathSeparatorChar);
                    classPath.append(Utils.quote(((File)iter.next()).getPath()));
                }
                result = classPath.toString();
            } else {
                LOGGER.log(Level.WARNING, "computeClassPath", "cpError");
            }
        }
        return result;
    }

    private static void appendOptions(StringBuilder argumentBuf, List<String> optList, Map<String, String> varMap) {
        String value;
        HashMap<String, String> keyValueArgs = new HashMap<String, String>();
        LinkedList<String> keyOrder = new LinkedList<String>();
        for (String opt : optList) {
            String name;
            int splitIndex = (opt = Utils.doSub(opt.trim(), varMap)).indexOf(61);
            if (splitIndex != -1 && !opt.startsWith("-agentpath:")) {
                name = opt.substring(0, splitIndex);
                value = Utils.quote(opt.substring(splitIndex + 1));
                LOGGER.log(Level.FINER, "appendOptions", "jvmOptVal", new Object[]{name, value});
            } else {
                name = opt;
                value = null;
                LOGGER.log(Level.FINER, "appendOptions", "jvmOpt", name);
            }
            if (!keyValueArgs.containsKey(name)) {
                keyOrder.add(name);
            }
            keyValueArgs.put(name, value);
        }
        String[] PROXY_PROPS = new String[]{"http.proxyHost", "http.proxyPort", "http.nonProxyHosts", "https.proxyHost", "https.proxyPort"};
        boolean isWindows = OsUtils.isWin();
        String[] stringArray = PROXY_PROPS;
        int n = PROXY_PROPS.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            value = System.getProperty(prop);
            if (value != null && value.trim().length() > 0) {
                if (isWindows && "http.nonProxyHosts".equals(prop)) {
                    value = "\"" + value + "\"";
                }
                keyValueArgs.put(JavaUtils.systemPropertyName(prop), value);
            }
            ++n2;
        }
        for (String key : keyOrder) {
            argumentBuf.append(' ');
            argumentBuf.append(key);
            if (keyValueArgs.get(key) == null) continue;
            argumentBuf.append("=");
            argumentBuf.append((String)keyValueArgs.get(key));
        }
    }

    private static void appendGlassfishArgs(StringBuilder glassfishArgs, List<String> glassfishArgsList) {
        for (String arg : glassfishArgsList) {
            glassfishArgs.append(' ');
            glassfishArgs.append(arg);
        }
        if (glassfishArgs.length() > 0) {
            glassfishArgs.deleteCharAt(0);
        }
    }

    public static enum StartMode {
        START,
        DEBUG,
        PROFILE;

    }
}

