/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.data.GlassFishConfig;
import org.eclipse.glassfish.tools.sdk.data.GlassFishJavaEEConfig;
import org.eclipse.glassfish.tools.sdk.data.GlassFishJavaSEConfig;
import org.eclipse.glassfish.tools.sdk.data.GlassFishLibrary;
import org.eclipse.glassfish.tools.sdk.server.config.ConfigBuilderProvider;
import org.eclipse.glassfish.tools.sdk.server.config.ConfigUtils;
import org.eclipse.glassfish.tools.sdk.server.config.GlassFishConfigManager;
import org.eclipse.glassfish.tools.sdk.server.config.LibraryNode;
import org.eclipse.glassfish.tools.sdk.server.config.ServerConfigException;
import org.eclipse.sapphire.Version;

public class ConfigBuilder {
    private final File classpathHome;
    private final File javadocsHome;
    private final File srcHome;
    private volatile boolean fetchDone;
    private List<GlassFishLibrary> libraryCache;
    private GlassFishJavaEEConfig javaEEConfigCache;
    private GlassFishJavaSEConfig javaSEConfigCache;
    private Version version;

    private static List<GlassFishLibrary> getLibraries(List<LibraryNode> libConfigs, File classpathHome, File javadocsHome, File srcHome) {
        LinkedList<GlassFishLibrary> result = new LinkedList<GlassFishLibrary>();
        try {
            for (LibraryNode libConfig : libConfigs) {
                List<File> classpath = ConfigUtils.processFileset(libConfig.classpath, classpathHome.getAbsolutePath());
                List<File> javadocs = ConfigUtils.processFileset(libConfig.javadocs, javadocsHome.getAbsolutePath());
                List<URL> javadocUrls = ConfigUtils.processLinks(libConfig.javadocs);
                List<File> sources = ConfigUtils.processFileset(libConfig.sources, srcHome.getAbsolutePath());
                result.add(new GlassFishLibrary(libConfig.libraryID, ConfigBuilder.buildUrls(classpath), ConfigBuilder.buildUrls(javadocs, javadocUrls), libConfig.javadocs.getLookups(), ConfigBuilder.buildUrls(sources), ConfigUtils.processClassPath(classpath)));
            }
        }
        catch (FileNotFoundException e) {
            throw new GlassFishIdeException("Some files required by configuration were not found.", e);
        }
        return result;
    }

    private static List<URL> buildUrls(List<File> files, List<URL> urls) {
        List<URL> result = ConfigBuilder.buildUrls(files);
        result.addAll(urls);
        return result;
    }

    private static List<URL> buildUrls(List<File> files) {
        ArrayList<URL> result = new ArrayList<URL>(files.size());
        for (File file : files) {
            URL url = ConfigUtils.fileToURL(file);
            if (url == null) continue;
            result.add(url);
        }
        return result;
    }

    ConfigBuilder(String classpathHome, String javadocsHome, String srcHome) {
        this.classpathHome = new File(classpathHome);
        this.javadocsHome = new File(javadocsHome);
        this.srcHome = new File(srcHome);
        this.fetchDone = false;
    }

    ConfigBuilder(File classpathHome, File javadocsHome, File srcHome) {
        this.classpathHome = classpathHome;
        this.javadocsHome = javadocsHome;
        this.srcHome = srcHome;
        this.fetchDone = false;
    }

    private void versionCheck(Version version) throws ServerConfigException {
        if (this.version == null) {
            this.version = version;
        } else if (this.version != version) {
            throw new ServerConfigException("Library builder was already used for GlassFish " + this.version + " use new instance for GlassFish" + version);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(Version version) {
        ConfigBuilder configBuilder = this;
        synchronized (configBuilder) {
            if (!this.fetchDone) {
                GlassFishConfig configAdapter = GlassFishConfigManager.getConfig(ConfigBuilderProvider.getBuilderConfig(version));
                List<LibraryNode> libConfigs = configAdapter.getLibrary();
                this.libraryCache = ConfigBuilder.getLibraries(libConfigs, this.classpathHome, this.javadocsHome, this.srcHome);
                this.javaEEConfigCache = new GlassFishJavaEEConfig(configAdapter.getJavaEE(), this.classpathHome);
                this.javaSEConfigCache = new GlassFishJavaSEConfig(configAdapter.getJavaSE());
                this.fetchDone = true;
            }
        }
    }

    public List<GlassFishLibrary> getLibraries(Version version) throws ServerConfigException {
        this.versionCheck(version);
        if (!this.fetchDone) {
            this.fetch(version);
        }
        return this.libraryCache;
    }

    public GlassFishJavaEEConfig getJavaEEConfig(Version version) throws ServerConfigException {
        this.versionCheck(version);
        if (!this.fetchDone) {
            this.fetch(version);
        }
        return this.javaEEConfigCache;
    }

    public GlassFishJavaSEConfig getJavaSEConfig(Version version) throws ServerConfigException {
        this.versionCheck(version);
        if (!this.fetchDone) {
            this.fetch(version);
        }
        return this.javaSEConfigCache;
    }
}

