/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.config;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.server.config.ConfigBuilder;
import org.eclipse.glassfish.tools.sdk.server.config.ServerConfigException;
import org.eclipse.sapphire.Version;

public class ConfigBuilderProvider {
    private static final Map<GlassFishServer, ConfigBuilder> builders = new HashMap<GlassFishServer, ConfigBuilder>();

    public static URL getBuilderConfig(Version version) {
        if (version.matches("[4")) {
            return ConfigBuilderProvider.class.getResource("GlassFishV4.xml");
        }
        return ConfigBuilderProvider.class.getResource("GlassFishV3.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigBuilder getBuilder(GlassFishServer server) {
        ConfigBuilder builder;
        if (server == null) {
            throw new ServerConfigException("GlassFish server entity shall not be null");
        }
        Map<GlassFishServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builder = builders.get((Object)server);
            if (builder != null) {
                return builder;
            }
            String serverHome = server.getServerHome();
            builder = new ConfigBuilder(serverHome, serverHome, serverHome);
            builders.put(server, builder);
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyBuilder(GlassFishServer server) {
        if (server == null) {
            throw new ServerConfigException("GlassFish server entity shall not be null");
        }
        Map<GlassFishServer, ConfigBuilder> map = builders;
        synchronized (map) {
            builders.remove((Object)server);
        }
    }
}

