/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.config;

import java.net.URL;
import java.util.List;
import org.eclipse.glassfish.tools.sdk.data.GlassFishConfig;
import org.eclipse.glassfish.tools.sdk.server.config.JavaEESet;
import org.eclipse.glassfish.tools.sdk.server.config.JavaSESet;
import org.eclipse.glassfish.tools.sdk.server.config.LibraryNode;
import org.eclipse.glassfish.tools.sdk.server.config.Tools;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderServer;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;

public class GlassFishConfigXMLImpl
implements GlassFishConfig {
    private final URL configFile;
    private final ConfigReaderServer reader = new ConfigReaderServer();
    private volatile boolean readDone;

    public GlassFishConfigXMLImpl(URL configFile) {
        this.configFile = configFile;
        this.readDone = false;
    }

    @Override
    public List<LibraryNode> getLibrary() {
        this.readXml();
        return this.reader.getLibraries();
    }

    @Override
    public JavaEESet getJavaEE() {
        this.readXml();
        return this.reader.getJavaEE();
    }

    @Override
    public JavaSESet getJavaSE() {
        this.readXml();
        return this.reader.getJavaSE();
    }

    @Override
    public Tools getTools() {
        this.readXml();
        return this.reader.getTools();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXml() {
        if (this.readDone) {
            return;
        }
        ConfigReaderServer configReaderServer = this.reader;
        synchronized (configReaderServer) {
            if (!this.readDone) {
                TreeParser.readXml(this.configFile, this.reader);
                this.readDone = true;
            }
        }
    }
}

