/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.config;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.glassfish.tools.sdk.server.config.ServerConfigException;

public enum JavaSEPlatform {
    v1_1,
    v1_2,
    v1_3,
    v1_4,
    v1_5,
    v1_6,
    v1_7,
    v1_8;

    public static final int length;
    public static final char SEPARATOR = '.';
    static final String V1_1_STR = "1.1";
    static final String V1_2_STR = "1.2";
    static final String V1_3_STR = "1.3";
    static final String V1_4_STR = "1.4";
    static final String V1_5_STR = "1.5";
    static final String V1_6_STR = "1.6";
    static final String V1_7_STR = "1.7";
    static final String V1_8_STR = "1.8";
    private static final Map<String, JavaSEPlatform> stringValuesMap;

    static {
        length = JavaSEPlatform.values().length;
        stringValuesMap = new HashMap<String, JavaSEPlatform>(JavaSEPlatform.values().length);
        JavaSEPlatform[] javaSEPlatformArray = JavaSEPlatform.values();
        int n = javaSEPlatformArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaSEPlatform platform = javaSEPlatformArray[n2];
            stringValuesMap.put(platform.toString().toUpperCase(), platform);
            ++n2;
        }
    }

    public static JavaSEPlatform toValue(String platformName) {
        if (platformName != null) {
            return stringValuesMap.get(platformName.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case v1_1: {
                return V1_1_STR;
            }
            case v1_2: {
                return V1_2_STR;
            }
            case v1_3: {
                return V1_3_STR;
            }
            case v1_4: {
                return V1_4_STR;
            }
            case v1_5: {
                return V1_5_STR;
            }
            case v1_6: {
                return V1_6_STR;
            }
            case v1_7: {
                return V1_7_STR;
            }
            case v1_8: {
                return V1_8_STR;
            }
        }
        throw new ServerConfigException("Invalid GlassFish JavaSE version");
    }
}

