/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.glassfish.tools.sdk.server.config.FileSet;
import org.eclipse.glassfish.tools.sdk.server.config.JavaEESet;
import org.eclipse.glassfish.tools.sdk.server.config.JavaSESet;
import org.eclipse.glassfish.tools.sdk.server.config.LibraryNode;
import org.eclipse.glassfish.tools.sdk.server.config.Tools;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderClasspath;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderJavaEE;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderJavaSE;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderJavadocs;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderSources;
import org.eclipse.glassfish.tools.sdk.server.parser.ConfigReaderTools;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.sdk.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigReaderServer
extends TreeParser.NodeListener
implements XMLReader {
    private ConfigReaderClasspath classpathReader = new ConfigReaderClasspath();
    private ConfigReaderJavadocs javadocsReader = new ConfigReaderJavadocs();
    private ConfigReaderSources sourcesReader = new ConfigReaderSources();
    private ConfigReaderJavaSE javaSEReader = new ConfigReaderJavaSE("/server");
    private ConfigReaderJavaEE javaEEReader = new ConfigReaderJavaEE("/server");
    private ConfigReaderTools configReaderTools = new ConfigReaderTools("/server");
    private List<LibraryNode> libraries = new LinkedList<LibraryNode>();
    private String actualLibID;

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        ArrayList<TreeParser.Path> paths = new ArrayList<TreeParser.Path>(14);
        paths.add(new TreeParser.Path("/server/library", this));
        paths.addAll(this.classpathReader.getPathsToListen());
        paths.addAll(this.javadocsReader.getPathsToListen());
        paths.addAll(this.sourcesReader.getPathsToListen());
        paths.addAll(this.javaSEReader.getPathsToListen());
        paths.addAll(this.javaEEReader.getPathsToListen());
        paths.addAll(this.configReaderTools.getPathsToListen());
        return paths;
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        this.actualLibID = attributes.getValue("id");
    }

    @Override
    public void endNode(String qname) throws SAXException {
        if ("library".equals(qname)) {
            FileSet classpath = new FileSet(this.classpathReader.getPaths(), this.classpathReader.getFilesets());
            FileSet javadocs = new FileSet(this.javadocsReader.getPaths(), this.javadocsReader.getLinks(), this.javadocsReader.getFilesets(), this.javadocsReader.getLookups());
            FileSet sources = new FileSet(this.sourcesReader.getPaths(), this.sourcesReader.getFilesets());
            LibraryNode config = new LibraryNode(this.actualLibID, classpath, javadocs, sources);
            this.libraries.add(config);
            this.actualLibID = null;
            this.classpathReader.reset();
            this.javadocsReader.reset();
            this.sourcesReader.reset();
        }
    }

    public List<LibraryNode> getLibraries() {
        return this.libraries;
    }

    public JavaEESet getJavaEE() {
        return this.javaEEReader.javaEE;
    }

    public JavaSESet getJavaSE() {
        return this.javaSEReader.javaSE;
    }

    public Tools getTools() {
        return this.configReaderTools.tools;
    }
}

