/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.parser;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.glassfish.tools.sdk.server.config.AsadminTool;
import org.eclipse.glassfish.tools.sdk.server.config.Tools;
import org.eclipse.glassfish.tools.sdk.server.parser.AbstractReader;
import org.eclipse.glassfish.tools.sdk.server.parser.ToolsAsadminReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.sdk.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ConfigReaderTools
extends AbstractReader
implements XMLReader {
    static final String NODE = "tools";
    private static final String LIB_ATTR = "lib";
    private String lib;
    private final ToolsAsadminReader toolsAsadminReader;
    Tools tools;

    ConfigReaderTools(String pathPrefix) {
        super(pathPrefix, NODE);
        this.toolsAsadminReader = new ToolsAsadminReader(this.path);
        this.lib = null;
        this.tools = null;
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path(this.path, this));
        paths.add(new TreeParser.Path(this.toolsAsadminReader.getPath(), this.toolsAsadminReader));
        return paths;
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        this.lib = attributes.getValue(LIB_ATTR);
    }

    @Override
    public void endNode(String qname) throws SAXException {
        if (NODE.equals(qname)) {
            if (this.tools != null) {
                throw new SAXException("Multiple tools XML element is not allowed.");
            }
            this.tools = new Tools(new AsadminTool(this.getLib(), this.getJar()));
            this.reset();
        }
    }

    String getLib() {
        return this.lib;
    }

    String getJar() {
        return this.toolsAsadminReader.getJar();
    }

    void reset() {
        this.lib = null;
        this.toolsAsadminReader.reset();
    }
}

