/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.parser.HttpData;
import org.eclipse.glassfish.tools.sdk.server.parser.TargetConfigReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.sdk.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class NetworkListenerReader
extends TargetConfigReader
implements XMLReader {
    private static final Logger LOGGER = new Logger(NetworkListenerReader.class);
    public static final String DEFAULT_PATH = "/domain/configs/config/network-config/network-listeners/network-listener";
    private String path;
    private Map<String, HttpData> result;

    public NetworkListenerReader(String targetConfigName) {
        this(DEFAULT_PATH, targetConfigName);
    }

    public NetworkListenerReader(String path, String targetConfigName) {
        super(targetConfigName);
        this.path = path;
        this.result = new HashMap<String, HttpData>();
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        if (readData) {
            try {
                String id = attributes.getValue("name");
                if (id != null && id.length() > 0) {
                    if (attributes.getValue("port").startsWith("$")) {
                        return;
                    }
                    int port = Integer.parseInt(attributes.getValue("port"));
                    boolean secure = "true".equals(attributes.getValue("security-enabled"));
                    boolean enabled = !"false".equals(attributes.getValue("enabled"));
                    LOGGER.log(Level.INFO, "readAttributes", "port", new Object[]{Integer.toString(port), Boolean.toString(enabled), Boolean.toString(secure)});
                    if (enabled) {
                        HttpData data = new HttpData(id, port, secure);
                        LOGGER.log(Level.INFO, "readAttributes", "add", data);
                        this.result.put(id, data);
                    }
                } else {
                    LOGGER.log(Level.INFO, "readAttributes", "noName");
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.SEVERE, "readAttributes", "numberFormat", ex);
            }
        }
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path(this.path, this));
        paths.add(new TreeParser.Path("/domain/configs/config", new TargetConfigReader.TargetConfigMarker(this)));
        return paths;
    }

    public Map<String, HttpData> getResult() {
        return this.result;
    }
}

