/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.parser;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.sdk.server.parser.XMLReader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ResourcesReader
extends TreeParser.NodeListener
implements XMLReader {
    private String path;
    private String keyName;
    private Map<String, String> properties = null;
    private Map<String, Map<String, String>> resourceData = new HashMap<String, Map<String, String>>();

    public ResourcesReader(ResourceType type) {
        this(type.getDefaultPath(), type.getDefaultKeyName());
    }

    public ResourcesReader(String path, String keyName) {
        this.path = path;
        this.keyName = keyName;
    }

    @Override
    public void readAttributes(String qname, Attributes attributes) throws SAXException {
        this.properties = new HashMap<String, String>();
        String resourceName = attributes.getValue(this.keyName);
        this.properties.put(this.keyName, resourceName);
        int attrLen = attributes.getLength();
        int i = 0;
        while (i < attrLen) {
            String name = attributes.getQName(i);
            String value = attributes.getValue(i);
            if (name != null && name.length() > 0 && value != null && value.length() > 0) {
                this.properties.put(name, value);
            }
            ++i;
        }
    }

    @Override
    public void readChildren(String qname, Attributes attributes) throws SAXException {
        String propName = String.valueOf(qname) + "." + attributes.getValue("name");
        this.properties.put(propName, attributes.getValue("value"));
    }

    @Override
    public void endNode(String qname) throws SAXException {
        String poolName = this.properties.get(this.keyName);
        this.resourceData.put(poolName, this.properties);
    }

    @Override
    public List<TreeParser.Path> getPathsToListen() {
        LinkedList<TreeParser.Path> paths = new LinkedList<TreeParser.Path>();
        paths.add(new TreeParser.Path(this.path, this));
        return paths;
    }

    public Map<String, Map<String, String>> getResourceData() {
        return this.resourceData;
    }

    public static enum ResourceType {
        JDBC_RESOURCE("/resources/jdbc-resource", "jndi-name"),
        JDBC_CONNECTION_POOL("/resources/jdbc-connection-pool", "name"),
        JAVA_MAIL("/resources/mail-resource", "jndi-name"),
        CONNECTOR_RESOURCE("/resources/connector-resource", "jndi-name"),
        CONNECTOR_POOL("/resources/connector-connection-pool", "name"),
        ADMIN_OBJECT_RESOURCE("/resources/admin-object-resource", "jndi-name");

        private String defaultKeyName;
        private String defaultPath;

        private ResourceType(String defaultPath, String defaultKeyName) {
            this.defaultPath = defaultPath;
            this.defaultKeyName = defaultKeyName;
        }

        public String getDefaultPath() {
            return this.defaultPath;
        }

        public String getDefaultKeyName() {
            return this.defaultKeyName;
        }
    }
}

