/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.state;

import org.eclipse.glassfish.tools.sdk.TaskEvent;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.TaskStateListener;
import org.eclipse.glassfish.tools.sdk.data.GlassFishStatusCheck;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.state.StatusJob;
import org.eclipse.glassfish.tools.sdk.server.state.StatusJobState;

public abstract class AbstractTask
implements Runnable {
    private static final Logger LOGGER = new Logger(AbstractTask.class);
    final StatusJob job;
    final StatusJob.Task task;
    final StatusJobState jobState;
    final GlassFishStatusCheck type;
    final TaskStateListener[] stateListeners;
    boolean cancelled;

    AbstractTask(StatusJob job, StatusJob.Task task, GlassFishStatusCheck type) {
        this.job = job;
        this.task = task;
        this.jobState = job.getState();
        this.type = type;
        this.stateListeners = task.getListeners();
        this.cancelled = false;
    }

    void cancel() {
        this.cancelled = true;
    }

    void handleStateChange(TaskState taskState, TaskEvent taskEvent, String ... args) {
        if (this.stateListeners != null && !this.cancelled) {
            int i = 0;
            while (i < this.stateListeners.length) {
                if (this.stateListeners[i] != null) {
                    this.stateListeners[i].operationStateChanged(taskState, taskEvent, args);
                }
                ++i;
            }
        }
    }
}

