/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.state;

import java.util.logging.Level;
import org.eclipse.glassfish.tools.sdk.TaskEvent;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.TaskStateListener;
import org.eclipse.glassfish.tools.sdk.admin.AdminFactory;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.Result;
import org.eclipse.glassfish.tools.sdk.admin.Runner;
import org.eclipse.glassfish.tools.sdk.data.GlassFishStatusCheck;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.server.state.AbstractTask;
import org.eclipse.glassfish.tools.sdk.server.state.StatusJob;

class RunnerTask
extends AbstractTask {
    private static final Logger LOGGER = new Logger(RunnerTask.class);
    private final Command cmd;
    Result result;

    RunnerTask(StatusJob job, StatusJob.RunnerTask task, GlassFishStatusCheck type) {
        super(job, task, type);
        this.cmd = task.getCommand();
        this.result = null;
    }

    @Override
    public void run() {
        int i;
        if (this.cancelled) {
            LOGGER.log(Level.FINER, "run", "cancelled");
            throw new IllegalStateException(LOGGER.excMsg("run", "cancelled"));
        }
        LOGGER.log(Level.FINER, "run", "started", new String[]{this.job.getStatus().getServer().getName(), this.jobState.toString()});
        TaskStateListener[] listeners = this.task.getListeners();
        AdminFactory af = AdminFactory.getInstance(this.job.getStatus().getServer().getAdminInterface());
        Runner runner = af.getRunner(this.job.getStatus().getServer(), this.cmd);
        if (listeners != null) {
            i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof StatusJob.Listener) {
                    ((StatusJob.Listener)listeners[i]).setRunner(runner);
                }
                ++i;
            }
        }
        runner.setStateListeners(new TaskStateListener[]{new RunnerListener(this)});
        runner.setReadyState();
        this.result = runner.call();
        if (listeners != null) {
            i = 0;
            while (i < listeners.length) {
                if (listeners[i] instanceof StatusJob.Listener) {
                    ((StatusJob.Listener)listeners[i]).clearRunner();
                }
                ++i;
            }
        }
    }

    private class RunnerListener
    implements TaskStateListener {
        final RunnerTask runnerTask;

        private RunnerListener(RunnerTask runnerTask2) {
            this.runnerTask = runnerTask2;
        }

        @Override
        public void operationStateChanged(TaskState newState, TaskEvent event, String ... args) {
            this.runnerTask.handleStateChange(newState, event, args);
        }
    }
}

