/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.server.state;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.glassfish.tools.sdk.GlassFishStatus;
import org.eclipse.glassfish.tools.sdk.data.DataException;
import org.eclipse.glassfish.tools.sdk.logging.Logger;

public enum StatusJobState {
    NO_CHECK,
    UNKNOWN,
    UNKNOWN_PORT,
    OFFLINE,
    OFFLINE_PORT,
    STARTUP,
    STARTUP_PORT,
    ONLINE,
    SHUTDOWN,
    SHUTDOWN_PORT;

    private static final Logger LOGGER;
    public static final int length;
    private static final String NO_CHECK_STR = "NO_CHECK";
    private static final String UNKNOWN_STR = "UNKNOWN";
    private static final String UNKNOWN_PORT_STR = "UNKNOWN_PORT";
    private static final String OFFLINE_STR = "OFFLINE";
    private static final String OFFLINE_PORT_STR = "OFFLINE_PORT";
    private static final String STARTUP_STR = "STARTUP";
    private static final String STARTUP_PORT_STR = "STARTUP_PORT";
    private static final String ONLINE_STR = "ONLINE";
    private static final String SHUTDOWN_STR = "SHUTDOWN";
    private static final String SHUTDOWN_PORT_STR = "SHUTDOWN_PORT";
    private static final Map<String, StatusJobState> stringValuesMap;
    private static final GlassFishStatus[] toGlassFishStatus;

    static {
        LOGGER = new Logger(StatusJobState.class);
        length = StatusJobState.values().length;
        stringValuesMap = new HashMap<String, StatusJobState>(length);
        StatusJobState[] statusJobStateArray = StatusJobState.values();
        int n = statusJobStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatusJobState state = statusJobStateArray[n2];
            stringValuesMap.put(state.toString().toUpperCase(), state);
            ++n2;
        }
        toGlassFishStatus = new GlassFishStatus[]{GlassFishStatus.UNKNOWN, GlassFishStatus.UNKNOWN, GlassFishStatus.UNKNOWN, GlassFishStatus.OFFLINE, GlassFishStatus.OFFLINE, GlassFishStatus.STARTUP, GlassFishStatus.STARTUP, GlassFishStatus.ONLINE, GlassFishStatus.SHUTDOWN, GlassFishStatus.SHUTDOWN};
    }

    public static StatusJobState toValue(String name) {
        if (name != null) {
            return stringValuesMap.get(name.toUpperCase());
        }
        return null;
    }

    public String toString() {
        switch (this) {
            case NO_CHECK: {
                return NO_CHECK_STR;
            }
            case UNKNOWN: {
                return UNKNOWN_STR;
            }
            case UNKNOWN_PORT: {
                return UNKNOWN_PORT_STR;
            }
            case OFFLINE: {
                return OFFLINE_STR;
            }
            case OFFLINE_PORT: {
                return OFFLINE_PORT_STR;
            }
            case STARTUP: {
                return STARTUP_STR;
            }
            case STARTUP_PORT: {
                return STARTUP_PORT_STR;
            }
            case ONLINE: {
                return ONLINE_STR;
            }
            case SHUTDOWN: {
                return SHUTDOWN_STR;
            }
            case SHUTDOWN_PORT: {
                return SHUTDOWN_PORT_STR;
            }
        }
        throw new DataException(LOGGER.excMsg("toString", "invalidVersion"));
    }

    GlassFishStatus toGlassFishStatus() {
        return toGlassFishStatus[this.ordinal()];
    }
}

