/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.utils;

import org.eclipse.glassfish.tools.sdk.logging.Logger;

public class CyclicStringBuffer {
    private static final Logger LOGGER = new Logger(CyclicStringBuffer.class);
    private int size;
    private char[] buff;
    private int len;
    private int beg;

    public CyclicStringBuffer(int size) {
        this.size = size;
        this.buff = new char[size];
        this.len = 0;
        this.beg = 0;
    }

    public void resize(int size) {
        if (this.size != size) {
            this.size = size;
            this.buff = new char[size];
        }
        this.len = 0;
        this.beg = 0;
    }

    public boolean append(char c) {
        this.buff[(this.beg + this.len) % this.size] = c;
        if (this.len == this.size) {
            this.beg = (this.beg + 1) % this.size;
            return true;
        }
        ++this.len;
        return false;
    }

    public boolean prepend(char c) {
        this.beg = (this.beg + this.size - 1) % this.size;
        this.buff[this.beg] = c;
        if (this.len == this.size) {
            return true;
        }
        ++this.len;
        return false;
    }

    public boolean equals(String s) {
        if (s == null) {
            return this.len == 0;
        }
        if (this.len != s.length()) {
            return false;
        }
        boolean result = true;
        int i = 0;
        while (i < this.len) {
            if (this.buff[(this.beg + i) % this.size] != s.charAt(i)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.len);
        int i = 0;
        while (i < this.len) {
            sb.append(this.buff[(this.beg + i) % this.size]);
            ++i;
        }
        return sb.toString();
    }
}

