/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.eclipse.glassfish.tools.sdk.utils.JarException;

public class Jar {
    public static final String MANIFEST_BUNDLE_VERSION = "Bundle-Version";
    private final JarInputStream jar;

    public Jar(File jarfile) {
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarfile));
        }
        catch (IOException ioe) {
            this.jar = null;
            throw new JarException("Cannot open JAR file.", ioe);
        }
        this.jar = jarStream;
    }

    public Jar(String jarfile) {
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarfile));
        }
        catch (IOException ioe) {
            this.jar = null;
            throw new JarException("Cannot open JAR file.", ioe);
        }
        this.jar = jarStream;
    }

    public Manifest getManifest() {
        return this.jar.getManifest();
    }

    public String getBundleVersion() {
        Manifest manifest = this.jar.getManifest();
        Attributes attrs = manifest != null ? manifest.getMainAttributes() : null;
        return attrs != null ? attrs.getValue(MANIFEST_BUNDLE_VERSION) : null;
    }

    public void close() {
        if (this.jar != null) {
            try {
                this.jar.close();
            }
            catch (IOException ioe) {
                throw new JarException("Cannot close JAR file.", ioe);
            }
        }
    }
}

