/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.glassfish.tools.sdk.GlassFishIdeException;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;

public class NetUtils {
    private static final org.eclipse.glassfish.tools.sdk.logging.Logger LOGGER = new org.eclipse.glassfish.tools.sdk.logging.Logger(ServerUtils.class);
    public static final int PORT_CHECK_TIMEOUT = 2000;
    private static byte[] TEST_QUERY;
    private static final InetAddressComparator INET_ADDRESS_COMPARATOR;

    static {
        byte[] byArray = new byte[118];
        byArray[0] = 22;
        byArray[1] = 3;
        byArray[4] = 83;
        byArray[5] = 1;
        byArray[8] = 79;
        byArray[9] = 3;
        byArray[11] = 63;
        byArray[12] = 71;
        byArray[13] = -41;
        byArray[14] = -9;
        byArray[15] = -70;
        byArray[16] = 44;
        byArray[17] = -18;
        byArray[18] = -22;
        byArray[19] = -78;
        byArray[20] = 96;
        byArray[21] = 126;
        byArray[22] = -13;
        byArray[24] = -3;
        byArray[25] = -126;
        byArray[26] = 123;
        byArray[27] = -71;
        byArray[28] = -43;
        byArray[29] = -106;
        byArray[30] = -56;
        byArray[31] = 119;
        byArray[32] = -101;
        byArray[33] = -26;
        byArray[34] = -60;
        byArray[35] = -37;
        byArray[36] = 60;
        byArray[37] = 61;
        byArray[38] = -37;
        byArray[39] = 111;
        byArray[40] = -17;
        byArray[41] = 16;
        byArray[42] = 110;
        byArray[45] = 40;
        byArray[47] = 22;
        byArray[49] = 19;
        byArray[51] = 10;
        byArray[53] = 102;
        byArray[55] = 5;
        byArray[57] = 4;
        byArray[59] = 101;
        byArray[61] = 100;
        byArray[63] = 99;
        byArray[65] = 98;
        byArray[67] = 97;
        byArray[69] = 96;
        byArray[71] = 21;
        byArray[73] = 18;
        byArray[75] = 9;
        byArray[77] = 20;
        byArray[79] = 17;
        byArray[81] = 8;
        byArray[83] = 6;
        byArray[85] = 3;
        byArray[86] = 1;
        byArray[88] = 71;
        byArray[89] = 69;
        byArray[90] = 84;
        byArray[91] = 32;
        byArray[92] = 47;
        byArray[93] = 99;
        byArray[94] = 111;
        byArray[95] = 109;
        byArray[96] = 95;
        byArray[97] = 115;
        byArray[98] = 117;
        byArray[99] = 110;
        byArray[100] = 95;
        byArray[101] = 119;
        byArray[102] = 101;
        byArray[103] = 98;
        byArray[104] = 95;
        byArray[105] = 117;
        byArray[106] = 105;
        byArray[107] = 32;
        byArray[108] = 72;
        byArray[109] = 84;
        byArray[110] = 84;
        byArray[111] = 80;
        byArray[112] = 47;
        byArray[113] = 49;
        byArray[114] = 46;
        byArray[115] = 48;
        byArray[116] = 10;
        byArray[117] = 10;
        TEST_QUERY = byArray;
        INET_ADDRESS_COMPARATOR = new InetAddressComparator();
    }

    public static boolean isPortListeningRemote(String host, int port, int timeout) {
        if (host == null) {
            return false;
        }
        Socket socket = null;
        try {
            socket = new Socket();
            socket.connect(new InetSocketAddress(host, port), timeout);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningRemote", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isPortListeningRemote(String host, int port) {
        return NetUtils.isPortListeningRemote(host, port, 0);
    }

    public static boolean isPortListeningLocal(String host, int port) {
        ServerSocket socket = null;
        try {
            InetAddress ia = InetAddress.getByName(host);
            socket = new ServerSocket(port, 1, ia);
            return false;
        }
        catch (IOException iOException) {
            return true;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "isPortListeningLocal", "closeError", ioe.getLocalizedMessage());
                }
            }
        }
    }

    public static boolean isHttpPortListeningLocal(String host, int port) {
        try {
            URLConnection conn = new URL("http://" + host + ":" + port).openConnection();
            conn.connect();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static boolean isLocahost(String host) {
        InetAddress localHostaddr;
        if (host == null || host.equals("")) {
            return false;
        }
        if ("localhost".equals(host = host.toLowerCase()) || "127.0.0.1".equals(host) || "::1".equals(host)) {
            return true;
        }
        try {
            localHostaddr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            Logger.getLogger(ServerUtils.class.getName()).log(Level.SEVERE, null, ex);
            return true;
        }
        return host.equals(localHostaddr.getHostName().toLowerCase()) || host.equals(localHostaddr.getHostAddress().toLowerCase());
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return NetUtils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        boolean isSecure;
        block25: {
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                Socket socket;
                block24: {
                    socket = new Socket();
                    try {
                        LOGGER.log(Level.FINE, "isSecurePort", "socket");
                        socket.connect(new InetSocketAddress(hostname, port), 2000);
                        socket.setSoTimeout(2000);
                    }
                    catch (SocketException ex) {
                        String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                        if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block24;
                        String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                        System.setProperty("socksNonProxyHosts", String.valueOf(socksNonProxyHosts) + localhost);
                        if (depth < 1) {
                            socket.close();
                            boolean bl = NetUtils.isSecurePort(hostname, port, 1);
                            if (socket != null) {
                                socket.close();
                            }
                            return bl;
                        }
                        socket.close();
                        ConnectException ce = new ConnectException();
                        ce.initCause(ex);
                        throw ce;
                    }
                }
                OutputStream ostream = socket.getOutputStream();
                ostream.write(TEST_QUERY);
                InputStream istream = socket.getInputStream();
                byte[] input = new byte[8192];
                istream.read(input);
                String response = new String(input).toLowerCase(Locale.ENGLISH);
                isSecure = true;
                if (response.length() == 0) {
                    socket.close();
                    throw new ConnectException();
                }
                if (response.startsWith("http/1.1 302 moved temporarily")) {
                    isSecure = true;
                } else if (response.startsWith("http/1.")) {
                    isSecure = false;
                } else if (response.indexOf("<html") != -1) {
                    isSecure = false;
                } else if (response.indexOf("</html") != -1) {
                    isSecure = false;
                } else if (response.indexOf("connection: ") != -1) {
                    isSecure = false;
                }
                break block25;
                finally {
                    if (socket != null) {
                        socket.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return isSecure;
    }

    public static Set<InetAddress> getHostIPs() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                List<InterfaceAddress> iAddrs = iface.getInterfaceAddresses();
                for (InterfaceAddress iAddr : iAddrs) {
                    addrs.add(iAddr.getAddress());
                }
            }
        }
        catch (SocketException socketException) {
            addrs = null;
            throw new GlassFishIdeException(LOGGER.excMsg("getHostIPs", "exception"));
        }
        return addrs;
    }

    public static Set<Inet4Address> getHostIP4s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                List<InterfaceAddress> iAddrs = iface.getInterfaceAddresses();
                for (InterfaceAddress iAddr : iAddrs) {
                    InetAddress addr = iAddr.getAddress();
                    if (!(addr instanceof Inet4Address)) continue;
                    addrs.add((Inet4Address)addr);
                }
            }
        }
        catch (SocketException socketException) {
            addrs = null;
            throw new GlassFishIdeException(LOGGER.excMsg("getHostIP4s", "exception"));
        }
        return addrs;
    }

    public static Set<Inet6Address> getHostIP6s() {
        TreeSet<InetAddress> addrs = new TreeSet<InetAddress>(INET_ADDRESS_COMPARATOR);
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                NetworkInterface iface = ifaces.nextElement();
                List<InterfaceAddress> iAddrs = iface.getInterfaceAddresses();
                for (InterfaceAddress iAddr : iAddrs) {
                    InetAddress addr = iAddr.getAddress();
                    if (!(addr instanceof Inet6Address)) continue;
                    addrs.add((Inet6Address)addr);
                }
            }
        }
        catch (SocketException socketException) {
            addrs = null;
            throw new GlassFishIdeException(LOGGER.excMsg("getHostIP6s", "exception"));
        }
        return addrs;
    }

    public static class InetAddressComparator
    implements Comparator<InetAddress> {
        @Override
        public int compare(InetAddress ip1, InetAddress ip2) {
            byte[] addr1 = ip1.getAddress();
            byte[] addr2 = ip2.getAddress();
            int result = addr2.length - addr1.length;
            if (result == 0) {
                int i = 0;
                while (result == 0 && i < addr1.length) {
                    result = addr1[i] - addr2[i];
                    ++i;
                }
            }
            return result;
        }
    }
}

