/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.sdk.utils;

import java.io.File;
import java.util.LinkedList;

public class OsUtils {
    public static final String LINES_SEPARATOR = System.getProperty("line.separator");
    public static final int FILE_SEPARATOR_LENGTH = File.separator.length();
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_NAME_UPCASE = OS_NAME != null ? OS_NAME.toUpperCase() : OS_NAME;
    private static final String OS_WIN_SUBSTR = "WINDOWS";
    private static final boolean IS_WIN = OS_NAME != null ? OS_NAME_UPCASE.contains("WINDOWS") : false;
    public static final String EXEC_SUFFIX = IS_WIN ? ".exe" : "";

    public static boolean isWin() {
        return IS_WIN;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String[] parseParameters(String exec, String args) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        LinkedList<String> params = new LinkedList<String>();
        params.add(exec);
        int state = NULL;
        StringBuilder buff = new StringBuilder(20);
        int slength = args.length();
        int i = 0;
        while (i < slength) {
            block26: {
                char c;
                block35: {
                    block37: {
                        block36: {
                            block30: {
                                block34: {
                                    block33: {
                                        block31: {
                                            block32: {
                                                block27: {
                                                    block29: {
                                                        block28: {
                                                            c = args.charAt(i);
                                                            if (!Character.isWhitespace(c)) break block27;
                                                            if (state != NULL) break block28;
                                                            if (buff.length() > 0) {
                                                                params.add(buff.toString());
                                                                buff.setLength(0);
                                                            }
                                                            break block26;
                                                        }
                                                        if (state != STICK) break block29;
                                                        params.add(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block26;
                                                    }
                                                    if (state == STICKPENDING) {
                                                        buff.append('\\');
                                                        params.add(buff.toString());
                                                        buff.setLength(0);
                                                        state = NULL;
                                                        break block26;
                                                    } else if (state == INPARAMPENDING) {
                                                        state = INPARAM;
                                                        buff.append('\\');
                                                        buff.append(c);
                                                        break block26;
                                                    } else {
                                                        buff.append(c);
                                                    }
                                                    break block26;
                                                }
                                                if (c != '\\') break block30;
                                                if (state != NULL) break block31;
                                                if (++i >= slength) break block32;
                                                char cc = args.charAt(i);
                                                if (cc == '\"' || cc == '\\') {
                                                    buff.append(cc);
                                                    break block26;
                                                } else if (Character.isWhitespace(cc)) {
                                                    buff.append(c);
                                                    --i;
                                                    break block26;
                                                } else {
                                                    buff.append(c);
                                                    buff.append(cc);
                                                }
                                                break block26;
                                            }
                                            buff.append('\\');
                                            break;
                                        }
                                        if (state != INPARAM) break block33;
                                        state = INPARAMPENDING;
                                        break block26;
                                    }
                                    if (state != INPARAMPENDING) break block34;
                                    buff.append('\\');
                                    state = INPARAM;
                                    break block26;
                                }
                                if (state == STICK) {
                                    state = STICKPENDING;
                                    break block26;
                                } else if (state == STICKPENDING) {
                                    buff.append('\\');
                                    state = STICK;
                                }
                                break block26;
                            }
                            if (c != '\"') break block35;
                            if (state != NULL) break block36;
                            state = INPARAM;
                            break block26;
                        }
                        if (state != INPARAM) break block37;
                        state = STICK;
                        break block26;
                    }
                    if (state == STICK) {
                        state = INPARAM;
                        break block26;
                    } else if (state == STICKPENDING) {
                        buff.append('\"');
                        state = STICK;
                        break block26;
                    } else {
                        buff.append('\"');
                        state = INPARAM;
                    }
                    break block26;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                } else if (state == STICKPENDING) {
                    buff.append('\\');
                    state = STICK;
                }
                buff.append(c);
            }
            ++i;
        }
        if (state == INPARAM) {
            params.add(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.add(buff.toString());
        } else if (buff.length() != 0) {
            params.add(buff.toString());
        }
        String[] retArgs = new String[params.size()];
        int i2 = 0;
        for (String param : params) {
            retArgs[i2++] = param;
        }
        return retArgs;
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < params.length) {
            OsUtils.escapeString(params[i], sb);
            sb.append(' ');
            ++i;
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    public static void escapeString(String s, StringBuffer sb) {
        if (s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s.length();
        int i = 0;
        while (i < slen) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
            } else if (c == '\\') {
                sb.append('\\').append('\\');
            } else if (c == '\"') {
                sb.append('\\').append('\"');
            } else {
                sb.append(c);
            }
            ++i;
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    public static String escapeString(String s) {
        int sLen;
        int tLen = sLen = s.length();
        boolean quote = sLen == 0;
        int i = 0;
        while (i < sLen) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    ++tLen;
                    break;
                }
                default: {
                    if (!Character.isWhitespace(c)) break;
                    quote = true;
                }
            }
            ++i;
        }
        if (quote) {
            tLen += 2;
        }
        StringBuilder sb = new StringBuilder(tLen);
        if (quote) {
            sb.append('\"');
        }
        int i2 = 0;
        while (i2 < sLen) {
            char c = s.charAt(i2);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(c);
            ++i2;
        }
        if (quote) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public static boolean rmDirContent(File target) {
        boolean result = true;
        if (target != null) {
            File[] content;
            File[] fileArray = content = target.listFiles();
            int n = content.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.canWrite()) {
                    if (file.isDirectory() && !".".equals(file.getName()) && !"..".equals(file.getName())) {
                        result = result && OsUtils.rmDirContent(file);
                    }
                    result = result && file.delete();
                } else {
                    result = false;
                }
                ++n2;
            }
        }
        return result;
    }

    public static boolean rmDir(File target) {
        boolean result = OsUtils.rmDirContent(target);
        return result && target.delete();
    }

    public static String joinPaths(String e1, String e2) {
        int l1 = e1 != null ? e1.length() : 0;
        int l2 = e2 != null ? e2.length() : 0;
        boolean separator = l1 > 0 && !e1.endsWith(File.separator);
        StringBuilder sb = new StringBuilder(l1 + l2 + (separator ? FILE_SEPARATOR_LENGTH : 0));
        if (l1 > 0) {
            sb.append(e1);
        }
        if (separator) {
            sb.append(File.separator);
        }
        if (l2 > 0) {
            sb.append(e2);
        }
        return sb.toString();
    }
}

