/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import org.eclipse.glassfish.tools.utils.JdtUtil;
import org.eclipse.jdt.launching.AbstractVMInstall;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.sapphire.DefaultValueService;

public abstract class JavaLocationDefaultValueService
extends DefaultValueService {
    private IVMInstallChangedListener listener;
    private boolean computing;

    protected void initDefaultValueService() {
        this.listener = new IVMInstallChangedListener(){

            public void vmRemoved(IVMInstall vm) {
                JavaLocationDefaultValueService.this.update();
            }

            public void vmChanged(PropertyChangeEvent event) {
                JavaLocationDefaultValueService.this.update();
            }

            public void vmAdded(IVMInstall vm) {
                JavaLocationDefaultValueService.this.update();
            }

            public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
            }
        };
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this.listener);
    }

    private synchronized void update() {
        if (!this.computing) {
            new Thread(){

                @Override
                public void run() {
                    JavaLocationDefaultValueService.this.refresh();
                }
            }.start();
        }
    }

    protected synchronized String compute() {
        this.computing = true;
        try {
            IVMInstall jvm = null;
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
                int n3 = iVMInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall vmInstall = iVMInstallArray[n4];
                    if (!JavaLocationDefaultValueService.internal(vmInstall) && this.acceptable(vmInstall)) {
                        jvm = JdtUtil.newer(jvm, vmInstall);
                    }
                    ++n4;
                }
                ++n2;
            }
            String string = jvm == null ? null : jvm.getInstallLocation().getAbsolutePath();
            return string;
        }
        finally {
            this.computing = false;
        }
    }

    private static boolean internal(IVMInstall jvm) {
        if (jvm instanceof AbstractVMInstall) {
            String internal = ((AbstractVMInstall)jvm).getAttribute("internal");
            return "true".equals(internal);
        }
        return false;
    }

    protected abstract boolean acceptable(IVMInstall var1);

    public void dispose() {
        super.dispose();
        if (this.listener != null) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this.listener);
            this.listener = null;
        }
    }
}

