/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.utils.JdkFilter;
import org.eclipse.glassfish.tools.utils.StreamGobbler;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Version;
import org.eclipse.sapphire.VersionConstraint;
import org.eclipse.sapphire.modeling.Status;
import org.osgi.framework.Bundle;

public final class JdtUtil {
    @Text(value="Java installation not found in the specified folder")
    private static LocalizableText invalidJavaLocationMessage;
    @Text(value="Java Development Kit (JDK) is required rather than a JRE")
    private static LocalizableText jdkIsRequiredMessage;
    @Text(value="Java {0} is required")
    private static LocalizableText javaVersionRequiredSingle;
    @Text(value="Java {0} or higher is required")
    private static LocalizableText javaVersionRequiredMin;
    @Text(value="Java {0} or lower is required")
    private static LocalizableText javaVersionRequiredMax;
    @Text(value="Java {0} or {1} is required")
    private static LocalizableText javaVersionRequiredOr;
    @Text(value="Java {0} through {1} is required")
    private static LocalizableText javaVersionRequiredRange;
    private static final Map<File, String> jvmLocationToVersionMap;
    private static final String[] fgCandidateJavaFiles;
    private static final String[] fgCandidateJavaLocations;

    static {
        LocalizableText.init(JdtUtil.class);
        jvmLocationToVersionMap = new HashMap<File, String>();
        fgCandidateJavaFiles = new String[]{"java", "java.exe"};
        fgCandidateJavaLocations = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    }

    public static JvmValidator validateJvm(File location) {
        return new JvmValidator(location);
    }

    public static JvmValidator validateJvm(IVMInstall jvm) {
        return new JvmValidator(jvm.getInstallLocation());
    }

    public static boolean isValidJvmInstall(IPath location) {
        return location != null && JdtUtil.isValidJvmInstall(location.toFile());
    }

    public static boolean isValidJvmInstall(File location) {
        return location != null && JdtUtil.findJavaExecutable(location) != null;
    }

    public static IVMInstallType findStandardJvmType() {
        return JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");
    }

    public static IVMInstall findOrCreateJvm(String location) {
        if (location != null) {
            return JdtUtil.findOrCreateJvm(new File(location));
        }
        return null;
    }

    public static IVMInstall findOrCreateJvm(File location) {
        IVMInstall jvm = null;
        if (JdtUtil.isValidJvmInstall(location) && (jvm = JdtUtil.findJvmByLocation(location)) == null) {
            String jvmName = JdtUtil.findUniqueJvmName(location.getName());
            IVMInstallType standardJvmType = JdtUtil.findStandardJvmType();
            VMStandin jvmStandin = new VMStandin(standardJvmType, jvmName);
            jvmStandin.setName(jvmName);
            jvmStandin.setInstallLocation(location);
            jvm = jvmStandin.convertToRealVM();
            try {
                JavaRuntime.saveVMConfiguration();
                JavaRuntime.getDefaultVMInstall();
            }
            catch (Exception e) {
                GlassfishToolsPlugin.log(e);
            }
        }
        return jvm;
    }

    public static final IVMInstall findJvmByLocation(String location) {
        if (location != null) {
            return JdtUtil.findJvmByLocation(new File(location));
        }
        return null;
    }

    public static final IVMInstall findJvmByLocation(File location) {
        if (location != null) {
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType type = iVMInstallTypeArray[n2];
                IVMInstall[] iVMInstallArray = type.getVMInstalls();
                int n3 = iVMInstallArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IVMInstall jvm = iVMInstallArray[n4];
                    if (location.equals(jvm.getInstallLocation())) {
                        return jvm;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static final IVMInstall findJvmByName(String name) {
        if (name != null) {
            IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
            int n = iVMInstallTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVMInstallType type = iVMInstallTypeArray[n2];
                IVMInstall jvm = type.findVMInstallByName(name);
                if (jvm != null) {
                    return jvm;
                }
                ++n2;
            }
        }
        return null;
    }

    public static IVMInstall findJdkByVersion(VersionConstraint versionConstraint) {
        return JdtUtil.findJvm(new JdkFilter(versionConstraint));
    }

    public static IVMInstall findJvm(Filter<IVMInstall> filter) {
        IVMInstall jvm = null;
        IVMInstallType[] iVMInstallTypeArray = JavaRuntime.getVMInstallTypes();
        int n = iVMInstallTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IVMInstallType vmInstallType = iVMInstallTypeArray[n2];
            IVMInstall[] iVMInstallArray = vmInstallType.getVMInstalls();
            int n3 = iVMInstallArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IVMInstall vmInstall = iVMInstallArray[n4];
                if (filter.allows((Object)vmInstall)) {
                    jvm = JdtUtil.newer(jvm, vmInstall);
                }
                ++n4;
            }
            ++n2;
        }
        return jvm == null ? null : jvm;
    }

    public static String findUniqueJvmName(String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException();
        }
        int counter = 0;
        boolean unique = false;
        String name = null;
        while (!unique) {
            name = String.valueOf(baseName) + (++counter == 1 ? "" : " (" + counter + ")");
            boolean bl = unique = JdtUtil.findJvmByName(name) == null;
        }
        return name;
    }

    public static IVMInstall newer(IVMInstall a, IVMInstall b) {
        String bv;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        String av = ((IVMInstall2)a).getJavaVersion();
        if (new Version(av).compareTo(new Version(bv = ((IVMInstall2)b).getJavaVersion())) >= 0) {
            return a;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectJavaVersion(File location) {
        if (location != null) {
            Map<File, String> map = jvmLocationToVersionMap;
            synchronized (map) {
                File exec;
                String version = jvmLocationToVersionMap.get(location);
                if (version == null && (exec = JdtUtil.findJavaExecutable(location)) != null) {
                    try {
                        Bundle bundle = Platform.getBundle((String)"org.eclipse.glassfish.tools.jver");
                        File cp = FileLocator.getBundleFile((Bundle)bundle);
                        if (cp.isDirectory()) {
                            cp = new File(cp, "bin");
                        }
                        Process process = Runtime.getRuntime().exec(new String[]{exec.getAbsolutePath(), "-cp", cp.getAbsolutePath(), "org.eclipse.glassfish.tools.jver.JavaVersionDetector"});
                        StreamGobbler outStreamGobbler = new StreamGobbler(process.getInputStream());
                        StreamGobbler errStreamGobbler = new StreamGobbler(process.getErrorStream());
                        outStreamGobbler.start();
                        errStreamGobbler.start();
                        try {
                            process.waitFor();
                        }
                        catch (InterruptedException interruptedException) {}
                        String output = String.valueOf(outStreamGobbler.output().trim()) + errStreamGobbler.output().trim();
                        if (output.length() > 0) {
                            version = output;
                            jvmLocationToVersionMap.put(location, version);
                        }
                    }
                    catch (Exception e) {
                        GlassfishToolsPlugin.log(e);
                    }
                }
                return version;
            }
        }
        return null;
    }

    private static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static void addToClasspath(IJavaProject project, IClasspathEntry entry) throws CoreException {
        IClasspathEntry[] oldEntries;
        IClasspathEntry[] iClasspathEntryArray = oldEntries = project.getRawClasspath();
        int n = oldEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry x = iClasspathEntryArray[n2];
            if (x.equals(entry)) {
                return;
            }
            ++n2;
        }
        int oldEntriesLength = oldEntries.length;
        IClasspathEntry[] newEntries = new IClasspathEntry[oldEntriesLength + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntriesLength);
        newEntries[oldEntriesLength] = entry;
        project.setRawClasspath(newEntries, null);
    }

    public static final class JvmValidator {
        private static final boolean IS_MACOSX = "macosx".equals(Platform.getOS());
        private File location;
        private Status status;

        private JvmValidator(File location) {
            this.location = location;
            this.status = JdtUtil.isValidJvmInstall(location) ? Status.createOkStatus() : Status.createErrorStatus((String)invalidJavaLocationMessage.text());
        }

        public JvmValidator jdk() {
            if (this.status.ok() && !IS_MACOSX && !new File(this.location, "lib/tools.jar").exists()) {
                this.status = Status.createErrorStatus((String)jdkIsRequiredMessage.text());
            }
            return this;
        }

        public JvmValidator version(String constraint) {
            if (this.status.ok()) {
                this.version(new VersionConstraint(constraint));
            }
            return this;
        }

        public JvmValidator version(VersionConstraint constraint) {
            if (this.status.ok() && constraint != null) {
                String[] segments;
                if (constraint.ranges().size() != 1) {
                    throw new IllegalArgumentException();
                }
                VersionConstraint.Range range = (VersionConstraint.Range)constraint.ranges().get(0);
                VersionConstraint.Range.Limit min = range.min();
                VersionConstraint.Range.Limit max = range.max();
                if (min != null && !min.inclusive()) {
                    throw new IllegalArgumentException();
                }
                if (max != null && !max.inclusive()) {
                    throw new IllegalArgumentException();
                }
                String version = JdtUtil.detectJavaVersion(this.location);
                if (version != null && (segments = version.split("\\.")).length >= 2) {
                    version = String.valueOf(segments[0]) + "." + segments[1];
                }
                if (version == null || !constraint.check(version)) {
                    Version maxver;
                    Version minver;
                    this.status = min == null ? Status.createErrorStatus((String)javaVersionRequiredMax.format(new Object[]{JvmValidator.toDisplayVersion(max.version())})) : (max == null ? Status.createErrorStatus((String)javaVersionRequiredMin.format(new Object[]{JvmValidator.toDisplayVersion(min.version())})) : ((minver = min.version()).equals((Object)(maxver = max.version())) ? Status.createErrorStatus((String)javaVersionRequiredSingle.format(new Object[]{JvmValidator.toDisplayVersion(minver)})) : (minver.segments().size() == 2 && maxver.segments().size() == 2 && minver.segment(1) + 1L == maxver.segment(1) ? Status.createErrorStatus((String)javaVersionRequiredOr.format(new Object[]{JvmValidator.toDisplayVersion(minver), JvmValidator.toDisplayVersion(maxver)})) : Status.createErrorStatus((String)javaVersionRequiredRange.format(new Object[]{JvmValidator.toDisplayVersion(minver), JvmValidator.toDisplayVersion(maxver)})))));
                }
            }
            return this;
        }

        public Status result() {
            return this.status;
        }

        private static String toDisplayVersion(Version version) {
            Long secondSegment;
            List segments = version.segments();
            if (segments.size() == 2 && (secondSegment = (Long)segments.get(1)) >= 5L) {
                return String.valueOf(secondSegment);
            }
            return version.toString();
        }
    }
}

