/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandListComponents;
import org.eclipse.glassfish.tools.sdk.admin.CommandListResources;
import org.eclipse.glassfish.tools.sdk.admin.CommandListWebServices;
import org.eclipse.glassfish.tools.sdk.admin.ResultList;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.data.IdeContext;
import org.eclipse.glassfish.tools.serverview.AppDesc;
import org.eclipse.glassfish.tools.serverview.ResourceDesc;
import org.eclipse.glassfish.tools.serverview.WSDesc;
import org.eclipse.glassfish.tools.utils.PartialCompletionException;
import org.eclipse.glassfish.tools.utils.ResourceUtils;

public class NodesUtils {
    public static List<ResourceDesc> getResources(GlassFishServer server, String type) {
        Object result = Collections.emptyList();
        LinkedList<ResourceDesc> retVal = null;
        try {
            CommandListResources command = new CommandListResources(CommandListResources.command(type), null);
            Future future = ServerAdmin.exec(server, (Command)command, new IdeContext());
            ResultList res = (ResultList)future.get();
            if (TaskState.COMPLETED.equals((Object)res.getState())) {
                result = res.getValue();
            }
            retVal = new LinkedList<ResourceDesc>();
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                String rsc = (String)iterator.next();
                retVal.add(new ResourceDesc(rsc, type));
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return retVal;
    }

    public static Map<String, List<AppDesc>> getApplications(GlassFishServer server, String container) {
        Object apps = Collections.emptyMap();
        CommandListComponents command = new CommandListComponents(null);
        Future future = ServerAdmin.exec(server, (Command)command, new IdeContext());
        ResultMap result = null;
        try {
            result = (ResultMap)future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        catch (TimeoutException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        if (result != null && result.getState().equals((Object)TaskState.COMPLETED)) {
            apps = result.getValue();
        }
        if (apps == null || apps.isEmpty()) {
            return Collections.emptyMap();
        }
        return NodesUtils.processApplications(apps);
    }

    private static Map<String, List<AppDesc>> processApplications(Map<String, List<String>> appsList) {
        HashMap<String, List<AppDesc>> result = new HashMap<String, List<AppDesc>>();
        for (Map.Entry<String, List<String>> entry : appsList.entrySet()) {
            String engine = entry.getKey();
            List<String> apps = entry.getValue();
            int i = 0;
            while (i < apps.size()) {
                String name = apps.get(i).trim();
                ArrayList<AppDesc> appList = (ArrayList<AppDesc>)result.get(engine);
                if (appList == null) {
                    appList = new ArrayList<AppDesc>();
                    result.put(engine, appList);
                }
                appList.add(new AppDesc(name, null, null, engine));
                ++i;
            }
        }
        return result;
    }

    public static List<WSDesc> getWebServices(GlassFishServer server) {
        Object wssList = Collections.emptyList();
        CommandListWebServices command = new CommandListWebServices();
        Future future = ServerAdmin.exec(server, (Command)command, new IdeContext());
        ResultList result = null;
        try {
            result = (ResultList)future.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        catch (ExecutionException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        catch (TimeoutException e) {
            Logger.getLogger("glassfish").log(Level.INFO, e.getMessage(), e);
        }
        if (result != null && result.getState().equals((Object)TaskState.COMPLETED)) {
            wssList = result.getValue();
        }
        if (wssList == null || wssList.isEmpty()) {
            return Collections.emptyList();
        }
        return NodesUtils.processWebServices(wssList);
    }

    private static List<WSDesc> processWebServices(List<String> wssList) {
        ArrayList<WSDesc> result = new ArrayList<WSDesc>();
        for (String a : wssList) {
            result.add(new WSDesc(a, String.valueOf(a) + "?wsdl", String.valueOf(a) + "?Tester"));
        }
        return result;
    }

    public static Map<String, String> getResourceData(GlassFishServer server, String name) {
        return ResourceUtils.getResourceData(server, name);
    }

    public static void putResourceData(GlassFishServer server, Map<String, String> data) throws PartialCompletionException {
        ResourceUtils.putResourceData(server, data);
    }
}

