/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.sdk.TaskState;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandGetProperty;
import org.eclipse.glassfish.tools.sdk.admin.CommandSetProperty;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.data.IdeContext;
import org.eclipse.glassfish.tools.sdk.server.parser.ResourcesReader;
import org.eclipse.glassfish.tools.sdk.server.parser.TreeParser;
import org.eclipse.glassfish.tools.utils.PartialCompletionException;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public class ResourceUtils {
    public static final String RESOURCE_FILE_TEMPLATE = "templates/sun-resources-xml-template.resource";
    public static final String RESOURCE_FILE_NAME = "sun-resources.xml";
    public static final String WEB_CONTENT = "WebContent";
    public static final String WEB_INF = "WEB-INF";
    public static final String EAR_CONTENT = "EarContent";
    public static final String EJB_CONTENT = "ejbModule";
    public static final String META_INF = "META-INF";
    private static final String SUN_RESOURCES_XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE resources PUBLIC \"-//Sun Microsystems, Inc.//DTD Application Server 9.0 Resource Definitions //EN\" \"http://www.sun.com/software/appserver/dtds/sun-resources_1_3.dtd\">\n<resources>\n";
    private static final String SUN_RESOURCES_XML_FOOTER = "</resources>\n";

    public static InputStream appendResource(IFile sunResourcesXml, String fragment) throws IOException, CoreException {
        String sunResourcesBuf = ResourceUtils.readResourceFile(sunResourcesXml);
        sunResourcesBuf = ResourceUtils.insertFragment(sunResourcesBuf, fragment);
        return new ByteArrayInputStream(sunResourcesBuf.getBytes(StandardCharsets.UTF_8));
    }

    public static String readResourceFile(IFile sunResourcesXml) throws IOException, CoreException {
        String content = null;
        if (sunResourcesXml.exists()) {
            InputStream is = null;
            Reader reader = null;
            try {
                IPath location = sunResourcesXml.getLocation();
                if (location != null) {
                    String encoding;
                    File resFile = location.toFile();
                    long flen = resFile.length();
                    if (flen > 1000000L) {
                        throw new IOException(String.valueOf(resFile.getAbsolutePath()) + " is too long to update.");
                    }
                    int length = (int)(2L * flen + 32L);
                    char[] buf = new char[length];
                    is = new BufferedInputStream(sunResourcesXml.getContents());
                    reader = new InputStreamReader(is, encoding = sunResourcesXml.getCharset());
                    int max = reader.read(buf);
                    if (max > 0) {
                        content = new String(buf, 0, max);
                    }
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }

    public static String insertFragment(String sunResourcesBuf, String fragment) throws IOException {
        String header = SUN_RESOURCES_XML_HEADER;
        String footer = SUN_RESOURCES_XML_FOOTER;
        boolean insertNewLine = false;
        if (sunResourcesBuf != null) {
            int closeIndex = sunResourcesBuf.indexOf("</resources>");
            if (closeIndex == -1) {
                throw new IOException("Malformed XML");
            }
            header = sunResourcesBuf.substring(0, closeIndex);
            footer = sunResourcesBuf.substring(closeIndex);
            if (closeIndex > 0 && sunResourcesBuf.charAt(closeIndex - 1) != '\n') {
                insertNewLine = true;
            }
        }
        int length = header.length() + footer.length() + 2;
        if (fragment != null) {
            length += fragment.length();
        }
        StringBuilder builder = new StringBuilder(length);
        builder.append(header);
        if (insertNewLine) {
            String lineSeparator = System.getProperty("line.separator");
            builder.append(lineSeparator != null ? lineSeparator : "\n");
        }
        if (fragment != null) {
            builder.append(fragment);
        }
        builder.append(footer);
        return builder.toString();
    }

    public static String replaceOrRemove(String originalLine, String pattern, String value) {
        String containsPattern = ".*" + pattern + ".*";
        if (originalLine != null && Pattern.matches(containsPattern, originalLine)) {
            return value == null || value.length() == 0 ? null : originalLine.replaceAll(pattern, value);
        }
        return originalLine;
    }

    public static String getResourceLocation(IProject project) {
        String setUpLocation = ResourceUtils.getProjectResourceLocation(project);
        if (setUpLocation == null) {
            if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
                setUpLocation = WEB_CONTENT + File.separatorChar + WEB_INF;
            } else if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
                setUpLocation = EAR_CONTENT;
            } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
                setUpLocation = EJB_CONTENT + File.separatorChar + META_INF;
            }
        } else if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            setUpLocation = String.valueOf(setUpLocation) + File.separatorChar + WEB_INF;
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            setUpLocation = String.valueOf(setUpLocation) + File.separatorChar + META_INF;
        }
        return setUpLocation;
    }

    public static String getRuntimeResourceLocation(IProject project) {
        String setUpLocation = null;
        if (JavaEEProjectUtilities.isDynamicWebProject((IProject)project)) {
            setUpLocation = WEB_INF;
        } else if (JavaEEProjectUtilities.isEARProject((IProject)project)) {
            setUpLocation = "";
        } else if (JavaEEProjectUtilities.isEJBProject((IProject)project)) {
            setUpLocation = META_INF;
        }
        return setUpLocation;
    }

    private static String getProjectResourceLocation(IProject project) {
        String setUpLocation = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        IVirtualFolder contentFolder = component.getRootFolder();
        IContainer resourceFolder = contentFolder.getUnderlyingFolder();
        setUpLocation = resourceFolder.getName();
        return setUpLocation;
    }

    private static IFile getSunResourceIFile(IProject selectedProject) {
        String dirName = ResourceUtils.getResourceLocation(selectedProject);
        IProject containerResource = selectedProject;
        IFolder folder = containerResource.getFolder((IPath)new Path(dirName));
        IFile file = folder.getFile((IPath)new Path(RESOURCE_FILE_NAME));
        return file;
    }

    public static File getSunResourceFile(IProject selectedProject) {
        File resFile = null;
        IFile sunResourcesXml = ResourceUtils.getSunResourceIFile(selectedProject);
        IPath location = sunResourcesXml.getLocation();
        if (location != null) {
            resFile = location.toFile();
        }
        return resFile;
    }

    public static List<String> getResources(IProject selectedProject, ResourcesReader.ResourceType ... types) {
        ArrayList<String> resources = new ArrayList<String>();
        if (selectedProject != null) {
            File xmlFile = ResourceUtils.getSunResourceFile(selectedProject);
            if (xmlFile.exists()) {
                ResourcesReader.ResourceType[] resourceTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourcesReader.ResourceType type = resourceTypeArray[n2];
                    ResourcesReader reader = new ResourcesReader(type);
                    TreeParser.readXml(xmlFile, reader);
                    resources.addAll(reader.getResourceData().keySet());
                    ++n2;
                }
            }
        } else {
            GlassfishToolsPlugin.logMessage("No valid project selected");
        }
        return resources;
    }

    public static void checkUpdateServerResources(File sunResourcesXml, GlassFishServer sunAppsrv) {
        Map<String, String> changedData = new HashMap<String, String>();
        ResourcesReader cpReader = new ResourcesReader(ResourcesReader.ResourceType.JDBC_CONNECTION_POOL);
        ResourcesReader jdbcReader = new ResourcesReader(ResourcesReader.ResourceType.JDBC_RESOURCE);
        ResourcesReader connectorPoolReader = new ResourcesReader(ResourcesReader.ResourceType.CONNECTOR_POOL);
        ResourcesReader connectorResourceReader = new ResourcesReader(ResourcesReader.ResourceType.CONNECTOR_RESOURCE);
        ResourcesReader aoReader = new ResourcesReader(ResourcesReader.ResourceType.ADMIN_OBJECT_RESOURCE);
        ResourcesReader mailReader = new ResourcesReader(ResourcesReader.ResourceType.JAVA_MAIL);
        try {
            TreeParser.readXml(sunResourcesXml, cpReader, jdbcReader, connectorPoolReader, connectorResourceReader, aoReader, mailReader);
        }
        catch (IllegalStateException ex) {
            GlassfishToolsPlugin.logError("Exception while reading resource file : " + sunResourcesXml, ex);
        }
        Map<String, String> allRemoteData = ResourceUtils.getResourceData(sunAppsrv, null);
        changedData = ResourceUtils.checkResources(cpReader, "resources.jdbc-connection-pool.", allRemoteData, changedData);
        changedData = ResourceUtils.checkResources(jdbcReader, "resources.jdbc-resource.", allRemoteData, changedData);
        changedData = ResourceUtils.checkResources(connectorPoolReader, "resources.connector-connection-pool.", allRemoteData, changedData);
        changedData = ResourceUtils.checkResources(connectorResourceReader, "resources.connector-resource.", allRemoteData, changedData);
        changedData = ResourceUtils.checkResources(aoReader, "resources.admin-object-resource.", allRemoteData, changedData);
        changedData = ResourceUtils.checkResources(mailReader, "resources.mail-resource.", allRemoteData, changedData);
        if (changedData.size() > 0) {
            try {
                ResourceUtils.putResourceData(sunAppsrv, changedData);
            }
            catch (PartialCompletionException e) {
                GlassfishToolsPlugin.logError("Some of the resources were not updated!", e);
            }
        }
    }

    public static Map<String, String> getResourceData(GlassFishServer server, String name) {
        try {
            String query = name != null ? "resources.*." + name + ".*" : "resources.*";
            CommandGetProperty command = new CommandGetProperty(query);
            Future future = ServerAdmin.exec(server, (Command)command, new IdeContext());
            ResultMap result = (ResultMap)future.get(30L, TimeUnit.SECONDS);
            if (TaskState.COMPLETED.equals((Object)result.getState())) {
                Object retVal = result.getValue();
                if (retVal.isEmpty()) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, new IllegalStateException(String.valueOf(query) + " has no data"));
                }
                return retVal;
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
        }
        return new HashMap<String, String>();
    }

    private static Map<String, String> checkResources(ResourcesReader resourceReader, String prefix, Map<String, String> allRemoteData, Map<String, String> changedData) {
        Set<String> resources = resourceReader.getResourceData().keySet();
        for (String jndiName : resources) {
            Map<String, String> localData = resourceReader.getResourceData().get(jndiName);
            String remoteKey = String.valueOf(prefix) + jndiName + ".";
            HashMap<String, String> remoteData = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : allRemoteData.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(remoteKey)) continue;
                remoteData.put(key, entry.getValue());
            }
            if (remoteData.size() <= 0) continue;
            changedData = ResourceUtils.getChangedData(remoteData, localData, changedData, remoteKey);
        }
        return changedData;
    }

    private static Map<String, String> getChangedData(Map<String, String> remoteData, Map<String, String> localData, Map<String, String> changedData, String resourceKey) {
        ArrayList<String> props = new ArrayList<String>();
        Set<String> localKeySet = localData.keySet();
        for (Map.Entry<String, String> entry : remoteData.entrySet()) {
            String localValue;
            String remoteDataKey = entry.getKey();
            String remoteValue = entry.getValue();
            String[] split = remoteDataKey.split(resourceKey);
            String key = split[1];
            if (key.indexOf("property.") != -1) {
                props.add(key);
            }
            if ((localValue = localData.get(key)) != null) {
                if (remoteValue != null && localValue.equals(remoteValue)) continue;
                changedData.put(remoteDataKey, localValue);
                continue;
            }
            if (!localKeySet.contains(key) || remoteValue == null) continue;
            changedData.put(remoteDataKey, localValue);
        }
        for (Map.Entry<String, String> entry : localData.entrySet()) {
            String key = entry.getKey();
            if (key.indexOf("property.") == -1 || props.contains(key)) continue;
            String remoteKey = String.valueOf(resourceKey) + key;
            changedData.put(remoteKey, entry.getValue());
        }
        return changedData;
    }

    public static void putResourceData(GlassFishServer server, Map<String, String> data) throws PartialCompletionException {
        String itemsNotUpdated = null;
        Exception lastEx = null;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            String compName = entry.getKey();
            String compValue = entry.getValue();
            try {
                CommandSetProperty command = new CommandSetProperty(compName, compValue);
                Future future = ServerAdmin.exec(server, (Command)command, new IdeContext());
                ResultString result = (ResultString)future.get(30L, TimeUnit.SECONDS);
                if (TaskState.COMPLETED.equals((Object)result.getState())) continue;
                itemsNotUpdated = ResourceUtils.addName(compName, itemsNotUpdated);
            }
            catch (InterruptedException ex) {
                lastEx = ex;
                Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
                itemsNotUpdated = ResourceUtils.addName(compName, itemsNotUpdated);
            }
            catch (Exception ex) {
                lastEx = ex;
                Logger.getLogger("glassfish").log(Level.INFO, ex.getMessage(), ex);
                itemsNotUpdated = ResourceUtils.addName(compName, itemsNotUpdated);
            }
        }
        if (itemsNotUpdated != null) {
            PartialCompletionException pce = new PartialCompletionException(itemsNotUpdated);
            if (lastEx != null) {
                pce.initCause(lastEx);
            }
            throw pce;
        }
    }

    private static String addName(String compName, String itemsNotUpdated) {
        String retVal = itemsNotUpdated;
        retVal = itemsNotUpdated != null ? String.valueOf(retVal) + ", " + compName : compName;
        return retVal;
    }

    public static String getUniqueResourceName(String name, List<String> resources) {
        int i = 1;
        String resourceName;
        while (resources.contains(resourceName = String.valueOf(name) + "_" + i)) {
            ++i;
        }
        return resourceName;
    }

    public static boolean isDuplicate(String name, List<String> resources) {
        boolean isDuplicate = false;
        if (resources.contains(name)) {
            isDuplicate = true;
        }
        return isDuplicate;
    }

    public static boolean isDuplicate(String name, ResourcesReader.ResourceType type, IProject selectedProject) {
        boolean isDuplicate = false;
        List<String> resources = ResourceUtils.getResources(selectedProject, type);
        if (resources.contains(name)) {
            isDuplicate = true;
        }
        return isDuplicate;
    }
}

