/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.glassfish.tools.GlassFishRuntime;
import org.eclipse.glassfish.tools.GlassFishServer;
import org.eclipse.glassfish.tools.GlassFishServerBehaviour;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.LastTaskEventListener;
import org.eclipse.glassfish.tools.ServerStatus;
import org.eclipse.glassfish.tools.sdk.TaskEvent;
import org.eclipse.glassfish.tools.sdk.admin.Command;
import org.eclipse.glassfish.tools.sdk.admin.CommandLocation;
import org.eclipse.glassfish.tools.sdk.admin.CommandVersion;
import org.eclipse.glassfish.tools.sdk.admin.ResultMap;
import org.eclipse.glassfish.tools.sdk.admin.ResultString;
import org.eclipse.glassfish.tools.sdk.admin.ServerAdmin;
import org.eclipse.glassfish.tools.sdk.utils.ServerUtils;
import org.eclipse.wst.server.core.IServer;

public class ServerStatusHelper {
    /*
     * Loose catch block
     */
    public static ServerStatus checkServerStatus(GlassFishServer server) {
        Future locationTask;
        ResultMap result;
        LastTaskEventListener listener;
        block30: {
            block32: {
                try {
                    Thread.sleep(Math.round(Math.random() * 1000.0));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return ServerStatus.NOT_DEFINED;
                }
                if (!ServerUtils.isAdminPortListening(server)) {
                    return ServerStatus.STOPPED_NOT_LISTENING;
                }
                if (server.isRemote()) {
                    IServer server1 = server.getServer();
                    String remoteServerVersion = GlassFishServerBehaviour.getVersion(server);
                    GlassFishRuntime gfRuntime = (GlassFishRuntime)((Object)server1.getRuntime().loadAdapter(GlassFishRuntime.class, null));
                    String thisServerVersion = gfRuntime.getVersion().toString();
                    int n = thisServerVersion.indexOf(".X");
                    if (n > 0) {
                        thisServerVersion = thisServerVersion.substring(0, n + 1);
                    }
                    if (remoteServerVersion != null && remoteServerVersion.indexOf(thisServerVersion) < 0) {
                        return ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                    }
                }
                CommandLocation command = new CommandLocation();
                listener = new LastTaskEventListener();
                result = null;
                locationTask = null;
                try {
                    locationTask = ServerAdmin.exec(server, (Command)command, listener);
                    result = (ResultMap)locationTask.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location interrupted");
                    if (result == null) {
                        if (locationTask != null) {
                            locationTask.cancel(true);
                        }
                        return ServerStatus.RUNNING_CONNECTION_ERROR;
                    }
                    break block30;
                }
                catch (ExecutionException e) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location throws exception");
                    e.printStackTrace();
                }
                catch (TimeoutException timeoutException) {
                    block31: {
                        GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location timed out");
                        if (result != null) break block30;
                        if (locationTask == null) break block31;
                        locationTask.cancel(true);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    return ServerStatus.RUNNING_CONNECTION_ERROR;
                }
                {
                    finally {
                        if (result == null) {
                            if (locationTask != null) {
                                locationTask.cancel(true);
                            }
                            return ServerStatus.RUNNING_CONNECTION_ERROR;
                        }
                        break block30;
                    }
                }
                if (result != null) break block30;
                if (locationTask == null) break block32;
                locationTask.cancel(true);
            }
            return ServerStatus.RUNNING_CONNECTION_ERROR;
        }
        ServerStatus s = null;
        switch (result.getState()) {
            case COMPLETED: {
                try {
                    if (ServerStatusHelper.domainMatching(server, (Map<String, String>)result.getValue())) {
                        s = ServerStatus.RUNNING_DOMAIN_MATCHING;
                        break;
                    }
                    s = ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                }
                catch (IOException iOException) {}
                break;
            }
            case FAILED: {
                if (ServerStatusHelper.isAuthException(listener.getLastEvent(), result)) {
                    s = ServerStatus.RUNNING_CREDENTIAL_PROBLEM;
                    break;
                }
                if (ServerStatusHelper.isRemoteAdminException(result)) {
                    s = ServerStatus.RUNNING_REMOTE_NOT_SECURE;
                    break;
                }
                if (listener.getLastEvent().equals((Object)TaskEvent.BAD_GATEWAY)) {
                    s = ServerStatus.RUNNING_PROXY_ERROR;
                    break;
                }
                s = ServerStatus.RUNNING_CONNECTION_ERROR;
                break;
            }
            case RUNNING: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location takes long time...");
                locationTask.cancel(true);
                s = ServerStatus.NOT_DEFINED;
                break;
            }
            default: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location in ready state");
                s = ServerStatus.NOT_DEFINED;
            }
        }
        return s;
    }

    /*
     * Loose catch block
     */
    private static ServerStatus checkServerStatusLocal(GlassFishServer server) {
        Future locationTask;
        ResultMap result;
        LastTaskEventListener listener;
        block24: {
            block26: {
                CommandLocation command = new CommandLocation();
                listener = new LastTaskEventListener();
                result = null;
                locationTask = null;
                try {
                    locationTask = ServerAdmin.exec(server, (Command)command, listener);
                    result = (ResultMap)locationTask.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location interrupted");
                    if (result == null) {
                        if (locationTask != null) {
                            locationTask.cancel(true);
                        }
                        return ServerStatus.RUNNING_CONNECTION_ERROR;
                    }
                    break block24;
                }
                catch (ExecutionException e) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location throws exception");
                    e.printStackTrace();
                }
                catch (TimeoutException timeoutException) {
                    block25: {
                        GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location timed out");
                        if (result != null) break block24;
                        if (locationTask == null) break block25;
                        locationTask.cancel(true);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    return ServerStatus.RUNNING_CONNECTION_ERROR;
                }
                {
                    finally {
                        if (result == null) {
                            if (locationTask != null) {
                                locationTask.cancel(true);
                            }
                            return ServerStatus.RUNNING_CONNECTION_ERROR;
                        }
                        break block24;
                    }
                }
                if (result != null) break block24;
                if (locationTask == null) break block26;
                locationTask.cancel(true);
            }
            return ServerStatus.RUNNING_CONNECTION_ERROR;
        }
        ServerStatus s = null;
        switch (result.getState()) {
            case COMPLETED: {
                try {
                    if (ServerStatusHelper.domainMatching(server, (Map<String, String>)result.getValue())) {
                        s = ServerStatus.RUNNING_DOMAIN_MATCHING;
                        break;
                    }
                    s = ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                }
                catch (IOException iOException) {}
                break;
            }
            case FAILED: {
                if (ServerStatusHelper.isAuthException(listener.getLastEvent(), result)) {
                    s = ServerStatus.RUNNING_CREDENTIAL_PROBLEM;
                    break;
                }
                if (ServerStatusHelper.isRemoteAdminException(result)) {
                    s = ServerStatus.RUNNING_REMOTE_NOT_SECURE;
                    break;
                }
                if (listener.getLastEvent().equals((Object)TaskEvent.BAD_GATEWAY)) {
                    s = ServerStatus.RUNNING_PROXY_ERROR;
                    break;
                }
                s = ServerStatus.RUNNING_CONNECTION_ERROR;
                break;
            }
            case RUNNING: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location takes long time...");
                locationTask.cancel(true);
                s = ServerStatus.NOT_DEFINED;
                break;
            }
            default: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location in ready state");
                s = ServerStatus.NOT_DEFINED;
            }
        }
        return s;
    }

    /*
     * Loose catch block
     */
    private static ServerStatus checkServerStatusRemote(GlassFishServer server) {
        Future locationTask;
        ResultString result;
        LastTaskEventListener listener;
        block22: {
            block24: {
                CommandVersion command = new CommandVersion();
                listener = new LastTaskEventListener();
                result = null;
                locationTask = null;
                try {
                    locationTask = ServerAdmin.exec(server, (Command)command, listener);
                    result = (ResultString)locationTask.get(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location interrupted");
                    if (result == null) {
                        if (locationTask != null) {
                            locationTask.cancel(true);
                        }
                        return ServerStatus.RUNNING_CONNECTION_ERROR;
                    }
                    break block22;
                }
                catch (ExecutionException e) {
                    GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location throws exception");
                    e.printStackTrace();
                }
                catch (TimeoutException timeoutException) {
                    block23: {
                        GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location timed out");
                        if (result != null) break block22;
                        if (locationTask == null) break block23;
                        locationTask.cancel(true);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    return ServerStatus.RUNNING_CONNECTION_ERROR;
                }
                {
                    finally {
                        if (result == null) {
                            if (locationTask != null) {
                                locationTask.cancel(true);
                            }
                            return ServerStatus.RUNNING_CONNECTION_ERROR;
                        }
                        break block22;
                    }
                }
                if (result != null) break block22;
                if (locationTask == null) break block24;
                locationTask.cancel(true);
            }
            return ServerStatus.RUNNING_CONNECTION_ERROR;
        }
        ServerStatus s = null;
        switch (result.getState()) {
            case COMPLETED: {
                if (ServerStatusHelper.versionMatching(server, result.getValue())) {
                    s = ServerStatus.RUNNING_DOMAIN_MATCHING;
                    break;
                }
                s = ServerStatus.STOPPED_DOMAIN_NOT_MATCHING;
                break;
            }
            case FAILED: {
                if (ServerStatusHelper.isAuthException(listener.getLastEvent(), result)) {
                    s = ServerStatus.RUNNING_CREDENTIAL_PROBLEM;
                    break;
                }
                if (ServerStatusHelper.isRemoteAdminException(result)) {
                    s = ServerStatus.RUNNING_REMOTE_NOT_SECURE;
                    break;
                }
                if (listener.getLastEvent().equals((Object)TaskEvent.BAD_GATEWAY)) {
                    s = ServerStatus.RUNNING_PROXY_ERROR;
                    break;
                }
                s = ServerStatus.RUNNING_CONNECTION_ERROR;
                break;
            }
            case RUNNING: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location takes long time...");
                locationTask.cancel(true);
                s = ServerStatus.NOT_DEFINED;
                break;
            }
            default: {
                GlassfishToolsPlugin.logMessage("ServerStatusMonitor for " + server.getName() + " location in ready state");
                s = ServerStatus.NOT_DEFINED;
            }
        }
        return s;
    }

    private static boolean versionMatching(GlassFishServer server, String version) {
        IServer server1 = server.getServer();
        GlassFishRuntime gfRuntime = (GlassFishRuntime)((Object)server1.getRuntime().getAdapter(GlassFishRuntime.class));
        String thisServerVersion = gfRuntime.getVersion().toString();
        int n = thisServerVersion.indexOf(".X");
        if (n > 0) {
            thisServerVersion = thisServerVersion.substring(0, n + 1);
        }
        return version == null || version.indexOf(thisServerVersion) >= 0;
    }

    private static boolean domainMatching(GlassFishServer server, Map<String, String> locationResult) throws IOException {
        if (server.isRemote()) {
            return true;
        }
        String expectedDomainRoot = String.valueOf(server.getDomainsFolder()) + File.separator + server.getDomainName();
        String actualDomainRoot = locationResult.get("Domain-Root_value");
        if (expectedDomainRoot != null && actualDomainRoot != null) {
            File expected = new File(expectedDomainRoot);
            File actual = new File(actualDomainRoot);
            if (expected.getCanonicalPath().equals(actual.getCanonicalPath())) {
                return true;
            }
        }
        return false;
    }

    private static boolean isAuthException(TaskEvent event, ResultMap<String, String> result) {
        return event.equals((Object)TaskEvent.AUTH_FAILED) || result.getValue() != null && result.getValue().get("message") != null && ((String)result.getValue().get("message")).contains("javax.security.auth.login.LoginException");
    }

    private static boolean isAuthException(TaskEvent event, ResultString result) {
        return event.equals((Object)TaskEvent.AUTH_FAILED) || result.getValue() != null && result.getValue().contains("javax.security.auth.login.LoginException");
    }

    private static boolean isRemoteAdminException(ResultMap<String, String> result) {
        return result.getValue() != null && result.getValue().get("message") != null && ((String)result.getValue().get("message")).contains("org.glassfish.internal.api.RemoteAdminAccessException");
    }

    private static boolean isRemoteAdminException(ResultString result) {
        return result.getValue() != null && result.getValue() != null && result.getValue().contains("org.glassfish.internal.api.RemoteAdminAccessException");
    }
}

