/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glassfish.tools.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.logging.Level;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.glassfish.tools.GlassfishToolsPlugin;
import org.eclipse.glassfish.tools.Messages;
import org.eclipse.glassfish.tools.sdk.logging.Logger;
import org.eclipse.glassfish.tools.sdk.utils.OsUtils;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.application.WebModule;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualArchiveComponent;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.model.IEARModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.javaee.application.Module;
import org.eclipse.jst.javaee.application.Web;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.DeletedModule;

public class Utils {
    private static final int PORT_CHECK_TIMEOUT = 4000;
    private static byte[] TEST_QUERY;

    static {
        byte[] byArray = new byte[118];
        byArray[0] = 22;
        byArray[1] = 3;
        byArray[4] = 83;
        byArray[5] = 1;
        byArray[8] = 79;
        byArray[9] = 3;
        byArray[11] = 63;
        byArray[12] = 71;
        byArray[13] = -41;
        byArray[14] = -9;
        byArray[15] = -70;
        byArray[16] = 44;
        byArray[17] = -18;
        byArray[18] = -22;
        byArray[19] = -78;
        byArray[20] = 96;
        byArray[21] = 126;
        byArray[22] = -13;
        byArray[24] = -3;
        byArray[25] = -126;
        byArray[26] = 123;
        byArray[27] = -71;
        byArray[28] = -43;
        byArray[29] = -106;
        byArray[30] = -56;
        byArray[31] = 119;
        byArray[32] = -101;
        byArray[33] = -26;
        byArray[34] = -60;
        byArray[35] = -37;
        byArray[36] = 60;
        byArray[37] = 61;
        byArray[38] = -37;
        byArray[39] = 111;
        byArray[40] = -17;
        byArray[41] = 16;
        byArray[42] = 110;
        byArray[45] = 40;
        byArray[47] = 22;
        byArray[49] = 19;
        byArray[51] = 10;
        byArray[53] = 102;
        byArray[55] = 5;
        byArray[57] = 4;
        byArray[59] = 101;
        byArray[61] = 100;
        byArray[63] = 99;
        byArray[65] = 98;
        byArray[67] = 97;
        byArray[69] = 96;
        byArray[71] = 21;
        byArray[73] = 18;
        byArray[75] = 9;
        byArray[77] = 20;
        byArray[79] = 17;
        byArray[81] = 8;
        byArray[83] = 6;
        byArray[85] = 3;
        byArray[86] = 1;
        byArray[88] = 71;
        byArray[89] = 69;
        byArray[90] = 84;
        byArray[91] = 32;
        byArray[92] = 47;
        byArray[93] = 99;
        byArray[94] = 111;
        byArray[95] = 109;
        byArray[96] = 95;
        byArray[97] = 115;
        byArray[98] = 117;
        byArray[99] = 110;
        byArray[100] = 95;
        byArray[101] = 119;
        byArray[102] = 101;
        byArray[103] = 98;
        byArray[104] = 95;
        byArray[105] = 117;
        byArray[106] = 105;
        byArray[107] = 32;
        byArray[108] = 72;
        byArray[109] = 84;
        byArray[110] = 84;
        byArray[111] = 80;
        byArray[112] = 47;
        byArray[113] = 49;
        byArray[114] = 46;
        byArray[115] = 48;
        byArray[116] = 10;
        byArray[117] = 10;
        TEST_QUERY = byArray;
    }

    public static String simplifyModuleID(String candidateID) {
        String moduleID = null;
        moduleID = candidateID.replace(' ', '_');
        if (moduleID.startsWith("/")) {
            moduleID = moduleID.substring(1);
        }
        moduleID = moduleID.replace('\\', '_').replace('/', '_');
        moduleID = moduleID.replace(':', '_').replace('*', '_');
        moduleID = moduleID.replace('?', '_').replace('\"', '_');
        moduleID = moduleID.replace('<', '_').replace('>', '_');
        moduleID = moduleID.replace('|', '_');
        moduleID = moduleID.replace(',', '_').replace('=', '_');
        return moduleID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canWrite(File location) {
        if (!OsUtils.isWin()) return location.canWrite();
        boolean retVal = true;
        File tmp = null;
        if (!location.exists()) {
            return false;
        }
        if (location.isDirectory()) {
            try {
                try {
                    tmp = File.createTempFile("foo", ".tmp", location);
                    return retVal;
                }
                catch (IOException iOException) {
                    retVal = false;
                    if (tmp == null) return retVal;
                    tmp.delete();
                }
                return retVal;
            }
            finally {
                if (tmp != null) {
                    tmp.delete();
                }
            }
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(location, true);
                return retVal;
            }
            catch (FileNotFoundException fileNotFoundException) {
                retVal = false;
                if (fos == null) return retVal;
                try {
                    fos.close();
                    return retVal;
                }
                catch (IOException ioe) {
                    Logger.log(Level.FINEST, null, ioe);
                }
            }
            return retVal;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    Logger.log(Level.FINEST, null, ioe);
                }
            }
        }
    }

    public static boolean isLocalPortOccupied(int port) {
        boolean retVal;
        block14: {
            ServerSocket ss = null;
            retVal = true;
            try {
                try {
                    ss = new ServerSocket(port);
                    retVal = false;
                }
                catch (IOException iOException) {
                    if (ss != null) {
                        try {
                            ss.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (ss != null) {
                    try {
                        ss.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
        return retVal;
    }

    public static String getHttpListenerProtocol(String hostname, int port) {
        String retVal = "http";
        try {
            if (Utils.isSecurePort(hostname, port)) {
                retVal = "https";
            }
        }
        catch (ConnectException ex) {
            Logger.log(Level.INFO, null, ex);
        }
        catch (SocketException ex) {
            Logger.log(Level.FINE, null, ex);
        }
        catch (SocketTimeoutException ex) {
            Logger.log(Level.INFO, null, ex);
        }
        catch (IOException ex) {
            Logger.log(Level.INFO, null, ex);
        }
        return retVal;
    }

    public static boolean isSecurePort(String hostname, int port) throws IOException, ConnectException, SocketTimeoutException {
        return Utils.isSecurePort(hostname, port, 0);
    }

    private static boolean isSecurePort(String hostname, int port, int depth) throws IOException, ConnectException, SocketTimeoutException {
        Socket socket;
        block13: {
            socket = new Socket();
            try {
                socket.connect(new InetSocketAddress(hostname, port), 4000);
                socket.setSoTimeout(4000);
            }
            catch (SocketException ex) {
                String socksNonProxyHosts = System.getProperty("socksNonProxyHosts");
                if (socksNonProxyHosts == null || socksNonProxyHosts.indexOf("localhost") >= 0) break block13;
                String localhost = socksNonProxyHosts.length() > 0 ? "|localhost" : "localhost";
                System.setProperty("socksNonProxyHosts", String.valueOf(socksNonProxyHosts) + localhost);
                if (depth < 1) {
                    socket.close();
                    return Utils.isSecurePort(hostname, port, 1);
                }
                socket.close();
                ConnectException ce = new ConnectException();
                ce.initCause(ex);
                throw ce;
            }
        }
        OutputStream ostream = socket.getOutputStream();
        ostream.write(TEST_QUERY);
        InputStream istream = socket.getInputStream();
        byte[] input = new byte[8192];
        istream.read(input);
        String response = new String(input, StandardCharsets.UTF_8).toLowerCase(Locale.ENGLISH);
        boolean isSecure = true;
        if (response.length() == 0) {
            socket.close();
            throw new ConnectException();
        }
        if (response.startsWith("http/1.1 302 moved temporarily")) {
            isSecure = true;
        } else if (response.startsWith("http/1.")) {
            isSecure = false;
        } else if (response.indexOf("<html") != -1) {
            isSecure = false;
        } else if (response.indexOf("</html") != -1) {
            isSecure = false;
        } else if (response.indexOf("connection: ") != -1) {
            isSecure = false;
        }
        socket.close();
        return isSecure;
    }

    public static final boolean hasProjectFacet(IModule module, IProjectFacet facet) {
        IFacetedProject facetProject;
        block7: {
            block6: {
                block5: {
                    try {
                        if (module != null) break block5;
                        return false;
                    }
                    catch (CoreException coreException) {
                        return false;
                    }
                }
                if (module.getProject() != null) break block6;
                return false;
            }
            facetProject = ProjectFacetsManager.create((IProject)module.getProject());
            if (facetProject != null) break block7;
            return false;
        }
        return facetProject.hasProjectFacet(facet);
    }

    public static String getAppWebContextRoot(IModule root, IModule module) {
        if (module instanceof DeletedModule || root instanceof DeletedModule) {
            return null;
        }
        if (module.getName().startsWith("lib/")) {
            IProject earProject = root.getProject();
            IVirtualComponent c = ComponentCore.createComponent((IProject)earProject);
            IVirtualReference[] iVirtualReferenceArray = c.getReferences();
            int n = iVirtualReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IVirtualReference ref = iVirtualReferenceArray[n2];
                IVirtualComponent comp = ref.getReferencedComponent();
                if (comp instanceof J2EEModuleVirtualArchiveComponent) {
                    J2EEModuleVirtualArchiveComponent archive = (J2EEModuleVirtualArchiveComponent)comp;
                    String aName = archive.getName();
                    if (module.getName().endsWith(aName)) {
                        return archive.getDeploymentPath().toPortableString();
                    }
                }
                ++n2;
            }
        }
        String context = null;
        try {
            IProject earProject = root.getProject();
            IEARModelProvider earModel = (IEARModelProvider)ModelProviderManager.getModelProvider((IProject)earProject);
            IVirtualFile appXmlFile = ComponentCore.createFile((IProject)earProject, (IPath)new Path("META-INF/application.xml"));
            IVirtualComponent c = ComponentCore.createComponent((IProject)module.getProject());
            String uri = earModel.getModuleURI(c);
            Object model = earModel.getModelObject();
            if (J2EEProjectUtilities.isJEEProject((IProject)earProject)) {
                if (appXmlFile.exists()) {
                    if (model instanceof org.eclipse.jst.javaee.application.Application) {
                        org.eclipse.jst.javaee.application.Application ee5App = (org.eclipse.jst.javaee.application.Application)model;
                        Module ee5Module = ee5App.getFirstModule(uri);
                        if (ee5Module == null) {
                            GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.errorAppWebContentRootMapping, (Object)module.getName()));
                        } else {
                            Web ee5Web = ee5Module.getWeb();
                            if (ee5Web == null) {
                                GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.errorAppWebContentRootMapping, (Object)module.getName()));
                            } else {
                                String contextRoot = ee5Web.getContextRoot();
                                context = contextRoot == null ? "" : contextRoot;
                            }
                        }
                    } else {
                        context = J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
                    }
                } else {
                    context = J2EEProjectUtilities.getServerContextRoot((IProject)module.getProject());
                }
            } else if (!appXmlFile.exists()) {
                GlassfishToolsPlugin.logMessage("Error reading application.xml");
            } else if (model instanceof Application) {
                Application ee14App = (Application)model;
                org.eclipse.jst.j2ee.application.Module ee14Module = ee14App.getFirstModule(uri);
                if (ee14Module == null) {
                    GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.errorAppWebContentRootMapping, (Object)module.getName()));
                } else if (!(ee14Module instanceof WebModule)) {
                    GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.errorAppWebContentRootMapping, (Object)module.getName()));
                } else {
                    String contextRoot = ((WebModule)ee14Module).getContextRoot();
                    context = contextRoot == null ? "" : contextRoot;
                }
            }
        }
        catch (Exception exception) {
            GlassfishToolsPlugin.logMessage(NLS.bind((String)Messages.errorAppWebContentRootMapping, (Object)module.getName()));
        }
        return context;
    }
}

